################################################################################
#	Makefile.sys	System build Makefile bits
#			T.Barnaby,	BEAM Ltd,	2006-07-20
################################################################################
#
#

libs		:= 

################################################################################
#	Kernel
################################################################################
#
kernelConfig:
	mkdir -p ${kernelBuildDir}
	cp config/kernelConfig ${kernelBuildDir}/.config
	+make -C ${kernelSrcDir} O=${kernelBuildDir} silentoldconfig

kernelXConfig:
	cp config/kernelConfig ${kernelBuildDir}/.config
	+make -C ${kernelSrcDir} O=${kernelBuildDir} xconfig
	cp ${kernelBuildDir}/.config config/kernelConfig

kernelAll:
	echo "Path: ${PATH}"
	+make -j8 -C ${kernelSrcDir} O=${kernelBuildDir} all modules
	#+make -j8 -C ${kernelSrcDir} O=${kernelBuildDir} zImage
	#+make -j8 -C ${kernelSrcDir} O=${kernelBuildDir} uImage
	#+make -j8 -C ${kernelSrcDir} O=${kernelBuildDir} modules

kernelInstall:
	mkdir -p ${rootDir}/boot
	rm -f ${rootDir}/boot/*
	#+make -C ${kernelSrcDir} O=${kernelBuildDir} INSTALL_PATH=${rootDir}/boot install
	#ln -fs vmlinuz-${kernelVersion} ${rootDir}/boot/vmlinuz
	#ln -fs System.map-${kernelVersion} ${rootDir}/boot/System.map
	cp kernel/arch/x86/boot/bzImage ${rootDir}/boot/vmlinuz
	cp kernel/System.map ${rootDir}/boot/System.map

kernelModulesInstall:
	#+make -C ${kernelSrcDir} O=${kernelBuildDir} INSTALL_MOD_PATH=${rootDir} modules_install
	mkdir -p ${rootDir}/lib/modules/${kernelVersion}
	@(for m in ${kernelModules}; do f=`find ${kernelBuildDir} -name $$m`; echo "Mod: $$m $$f"; cp $$f ${rootDir}/lib/modules/${kernelVersion}; strip --strip-debug ${rootDir}/lib/modules/${kernelVersion}/$$m; done)
	cp ${kernelBuildDir}/modules.order ${kernelBuildDir}/modules.builtin ${rootDir}/lib/modules/${kernelVersion}
	depmod -b ${rootDir} ${kernelVersion}

kernelModulesInstallAll:
	+make -C ${kernelSrcDir} O=${kernelBuildDir} INSTALL_MOD_PATH=${rootDir} modules_install

kernelModulesInstallOld:
	+make -C ${kernelSrcDir} O=${kernelBuildDir} INSTALL_MOD_PATH=${rootDir} modules_install
	rm -fr ${rootDir}/lib/modules/3.12.10/kernel
	-mkdir -p ${rootDir}/lib/modules/3.12.10/kernel/drivers/usb/gadget
	cp ${kernelBuildDir}/drivers/usb/gadget/g_ether.ko ${rootDir}/lib/modules/3.12.10/kernel/drivers/usb/gadget/g_ether.ko
	cp ${kernelBuildDir}/drivers/usb/gadget/libcomposite.ko ${rootDir}/lib/modules/3.12.10/kernel/drivers/usb/gadget/libcomposite.ko
	cp ${kernelBuildDir}/drivers/usb/gadget/u_ether.ko ${rootDir}/lib/modules/3.12.10/kernel/drivers/usb/gadget/u_ether.ko
	cp ${kernelBuildDir}/drivers/usb/gadget/u_rndis.ko ${rootDir}/lib/modules/3.12.10/kernel/drivers/usb/gadget/u_rndis.ko
	cp ${kernelBuildDir}/drivers/usb/gadget/usb_f_rndis.ko ${rootDir}/lib/modules/3.12.10/kernel/drivers/usb/gadget/usb_f_rndis.ko
	cp ${kernelBuildDir}/drivers/usb/gadget/usb_f_ecm.ko ${rootDir}/lib/modules/3.12.10/kernel/drivers/usb/gadget/usb_f_ecm.ko
	-mkdir -p ${rootDir}/lib/modules/3.12.10/kernel/fs/configfs
	cp ${kernelBuildDir}/fs/configfs/configfs.ko ${rootDir}/lib/modules/3.12.10/kernel/fs/configfs/configfs.ko


kernelClean:
	make -C ${kernelSrcDir} O=${kernelBuildDir} clean
	rm -fr ${kernelBuildDir}/*


################################################################################
#	Admxrc driver
################################################################################
#
admxrcConfig:
	make -C admxrc config
	
admxrcClean:
	make -C admxrc clean

admxrcAll:
	make -C admxrc driver

admxrcInstall:
	make -C admxrc driver_install
	#mkdir -p ${rootDir}/lib/modules/${kernelVersion}/kernel/misc
	#cp -a ${admxrcSrcDir}/driver/monolithic/linux/admxrc2.ko ${rootDir}/lib/modules/${kernelVersion}/kernel/misc
	#cp -a ${admxrcSrcDir}/api/modules/admxrc2/linux/obj/libadmxrc2.so.2.4.3.0 ${rootDir}/lib/libadmxrc2.so.2



################################################################################
#	Rootfs
################################################################################
#
rootfsConfig:
	sed -e "s|^CONFIG_PREFIX=.*|CONFIG_PREFIX=\"${rootDir}\"|" config/busyboxConfig > ${rootfsBuildDir}/.config
	+make -C ${rootfsSrcDir} O=${rootfsBuildDir} oldconfig

rootfsXConfig:
	sed -e "s|^CONFIG_PREFIX=.*|CONFIG_PREFIX=\"${rootDir}\"|" config/busyboxConfig > ${rootfsBuildDir}/.config
	+make -C ${rootfsSrcDir} O=${rootfsBuildDir} menuconfig
	cp ${rootfsBuildDir}/.config config/busyboxConfig

rootfsDefaultConfig:
	+make -C ${rootfsSrcDir} O=${rootfsBuildDir} defconfig

rootfsAll:
	#+make -C ${rootfsSrcDir} O=${rootfsBuildDir} all
	+make -C ${rootfsSrcDir} O=${rootfsBuildDir} all

rootfsInstall:	rootfsInstallBase rootfsInstallLibs rootfsInstallBins
	+make -C ${rootfsSrcDir} O=${rootfsBuildDir} PREFIX=${rootDir} install

rootfsClean:
	+make -C ${rootfsSrcDir} O=${rootfsBuildDir} clean

rootfsInstallBase:
	mkdir -p ${rootDir}
	mkdir -p ${rootDir}/boot
	mkdir -p ${rootDir}/lib
	-ln -s lib ${rootDir}/lib64
	mkdir -p ${rootDir}/lib/modules
	mkdir -p ${rootDir}/bin
	mkdir -p ${rootDir}/dev
	mkdir -p ${rootDir}/etc
	mkdir -p ${rootDir}/etc/init.d
	mkdir -p ${rootDir}/proc
	mkdir -p ${rootDir}/sys
	mkdir -p ${rootDir}/sysroot
	mkdir -p ${rootDir}/sbin
	mkdir -p ${rootDir}/tmp
	mkdir -p ${rootDir}/usr
	mkdir -p ${rootDir}/usr/bin
	mkdir -p ${rootDir}/usr/lib
	mkdir -p ${rootDir}/usr/tms
	mkdir -p ${rootDir}/var
	mkdir -p ${rootDir}/mnt
	mkdir -p ${rootDir}/data
	mkdir -p ${rootDir}/src

	#mkdir -p ${rootDir}/var/log
	ln -sf /tmp/var/log ${rootDir}/var/log
	
	mkdir -p ${rootDir}/var/www
	mkdir -p ${rootDir}/var/www/cgi-bin
	mkdir -p ${rootDir}/var/lib/nfs/rpc_pipefs

	ln -sf /tmp/resolv.conf ${rootDir}/etc/resolv.conf

	cp -a rootfsFiles/* ${rootDir}

rootfsInstallBins:
	for f in ${rootfsBins}; do cp `find /sbin /usr/sbin /bin /usr/bin -maxdepth 1 -name $$f` ${rootDir}/bin; done

rootfsInstallDev:
	rm -f ${rootDir}/dev/*
	mknod ${rootDir}/dev/console c 5 1

rootfsInstallLibs:
	cp ${rootfsSharedLibs} ${rootDir}/lib
	-/usr/sbin/prelink -u ${rootDir}/lib/*.so*

################################################################################
#	NfsBoot
################################################################################
#
nfsBootInstall:
	-mkdir -p ${sysDir}/var/lib/tftpboot/${project}
	cp -a ${srcDir}/networkBoot/pxelinux.0 ${srcDir}/networkBoot/pxelinux.cfg ${sysDir}/var/lib/tftpboot/${project}
	cp -a ${rootDir}/boot/vmlinuz* ${sysDir}/var/lib/tftpboot/${project}
	${srcDir}/networkBoot/mknfsinitrd -d ${rootDir} ${sysDir}/var/lib/tftpboot/${project}/initrd.img ${kernelVersion}
