################################################################################
#	Makefile.config		Configurationm options for build
#				T.Barnaby,	BEAM Ltd,	2007-02-22
################################################################################
#
#

# The main version
PROJECT		= TMS
GIT_URL 	= beam.beamnet:/data/git/Cern/tms
VERSION		= 2.1.0
RELEASE		= 2.beam
TARGET		?=
DIST		?=
PREFIX		?= /usr/tms

ifeq ("$(TARGET)", "")
TARGET			= $(shell cut -d " " -f1 /etc/bsystype.txt)
endif
ifeq ("$(DIST)", "")
DIST			= $(shell cut -d " " -f2 /etc/bsystype.txt)
endif

ifeq ("$(TARGET)", "")
$(error TARGET not defined)
endif

ifeq ("$(DIST)", "")
$(error DIST not defined)
endif

# Build Settings
arch		= i686

# Build Settings
ifeq ("${arch}","x86_64")
arch_lib	= ${arch_lib}
else
arch_lib	= lib
endif

#rpmDir		= /usr/src/redhat
rpmDir		= /scratch/rpms
#rpmDir		= ${HOME}/rpmbuild

# Base directories
srcDir		= ${shell pwd}
#srcDir		= /src/cern/tms-mcsys
srcIncDir	= ${srcDir}/include
srcLibDir	= ${srcDir}/lib
sysSrcDir	= ${srcDir}/src

# Root file system dir
ifeq ("$(DESTDIR)", "")
baseDir		= ${srcDir}
rootDir		= ${srcDir}/rootfs
sysDir		= ${srcDir}
else
baseDir		= ${DESTDIR}/usr/tms
rootDir		= ${baseDir}/rootfs
sysDir		= ${DESTDIR}
endif

kernelVersion	= 3.10.107
kernelModules	= igb.ko e1000.ko e1000e.ko pps_core.ko mii.ko nfs.ko sunrpc.ko auth_rpcgss.ko nfs_acl.ko fscache.ko lockd.ko nfs.ko ptp.ko
kernelModules	+= i2c-core.ko i2c-algo-bit.ko dca.ko nfsv3.ko nfsv4.ko
kernelModules	+= dns_resolver.ko
kernelModules	+= ipmi_msghandler.ko ipmi_watchdog.ko ipmi_devintf.ko ipmi_si.ko

kernelSrcDir	= ${sysSrcDir}/kernel/linux-${kernelVersion}
kernelBuildDir	= ${srcDir}/kernel

admxrcVersion	= 4.3.0b3
admxrcSrcDir	= admxrc/admxrc_drv-${admxrcVersion}

# Rootfs build options
rootfsVersion		= 1.27.2
rootfsSrcDir		= ${sysSrcDir}/busybox/busybox-${rootfsVersion}
rootfsBuildDir		= ${shell pwd}/rootfs-build
rootfsSharedLibs	= /${arch_lib}/libcrypt.so.1 /${arch_lib}/libm.so.6 /${arch_lib}/libc.so.6 
rootfsSharedLibs	+= /${arch_lib}/libfreebl3.so /${arch_lib}/libdl.so.2 /${arch_lib}/libpci.so.3
rootfsSharedLibs	+= /${arch_lib}/libgcc_s.so.1 /usr/${arch_lib}/libstdc++.so.6 /${arch_lib}/libpthread.so.0
rootfsSharedLibs	+= /${arch_lib}/libnss_files.so.2 /${arch_lib}/libnss_dns.so.2 /${arch_lib}/libresolv.so.2
rootfsSharedLibs	+= /${arch_lib}/libpci.so.3
rootfsSharedLibs	+= /${arch_lib}/ld-linux.so.2
#rootfsSharedLibs	+= /${arch_lib}/ld-linux-x86-64.so.2
#rootfsSharedLibs	+= /${arch_lib}/linux-vdso.so.1
rootfsBins		= lspci


all::

# TARGET Special Settings
ifeq ("$(TARGET)", "fedora")

# Build RPM packages
RPMBUILD_DIR	= ${HOME}/rpmbuild
DISTDIR_RELEASE	= /dist/cern/tms/${TARGET}_${DIST}

packages: package/rpm/tms-mcsys.spec
	rpmbuild --define "_topdir $(RPMBUILD_DIR)" --target noarch --build-in-place -bb package/rpm/tms-mcsys.spec

packages-install:
	cp ${RPMBUILD_DIR}/RPMS/noarch/tms-mcsys*.noarch.rpm ${DISTDIR_RELEASE}/packages
	createrepo ${DISTDIR_RELEASE}

.SUFFIXES: .spec

%.spec:	Config.mk
	@(if ! grep "^Version:.*${VERSION}" $@; then sed -i -e "s/^Version:.*/Version:\t${VERSION}/" $@; fi) 2>&1 > /dev/null
	@(if ! grep "^Release:.*${RELEASE}" $@; then sed -i -e "s/^Release:.*/Release:\t${RELEASE}%{dist}/" $@; fi) 2>&1 > /dev/null

else ifeq ("$(TARGET)", "debian")
# Build DEB packages
DEBBUILD_DIR	= /tmp/debbuild
DISTDIR_RELEASE	= /dist/cern/tms/${TARGET}_${DIST}

packages:
	-rm -fr ${DEBBUILD_DIR}
	-mkdir -p ${DEBBUILD_DIR}/tms-mcsys
	cp -a Makefile Config.mk images package/debian ${DEBBUILD_DIR}/tms-mcsys
	sed -i -e "s/tms-mcsys (.*)/tms-mcsys (${VERSION}-${RELEASE})/" ${DEBBUILD_DIR}/tms-mcsys/debian/changelog
	(cd ${DEBBUILD_DIR}/tms-mcsys; dpkg-buildpackage -us -uc -nc -b)
	#lintian ${DEBBUILD_DIR}/tms-mcsys-${VERSION}${RELEASE}*.deb
	-rm -fr ${DEBBUILD_DIR}/tms-mcsys

packages-install:
	mkdir -p ${DISTDIR_RELEASE}/pool/main
	cp ${DEBBUILD_DIR}/*.deb ${DISTDIR_RELEASE}/pool/main
	sh package/debian/createrepo.sh ${DISTDIR_RELEASE}

else
	$(error TARGET not defined)
endif
