#!/bin/sh
##########################################################################################
#	createrepo.sh	Create a Debian package repository in given directory
##########################################################################################
#
set -e

DIR=$1

do_hash() {
    HASH_NAME=$1
    HASH_CMD=$2
    echo "${HASH_NAME}:"
    for f in $(find dists/stable -type f); do
        fn=$(echo $f | sed -e "s@dists/stable/@@") # remove ./ prefix
        if [ "$f" = "Release" ]; then
            continue
        fi
        echo " $(${HASH_CMD} ${f}  | cut -d" " -f1) $(wc -c $f | cut -d" " -f1) $fn"
    done
}

echo "Create repo in ${DIR}"
cd ${DIR}
mkdir -p dists/stable/main/binary-amd64
dpkg-scanpackages --arch amd64 pool/ > dists/stable/main/binary-amd64/Packages
gzip -9 -c dists/stable/main/binary-amd64/Packages > dists/stable/main/binary-amd64/Packages.gz

cat > dists/stable/Release << EOF
Origin: TMS Repository
Label: TMS
Suite: stable
Codename: stable
Version: 1.0
Architectures: amd64
Components: main
Description: Beam Cern TMS package repository
Date: $(date -Ru)
EOF

do_hash "MD5Sum" "md5sum" >> dists/stable/Release
do_hash "SHA1" "sha1sum" >> dists/stable/Release
do_hash "SHA256" "sha256sum" >> dists/stable/Release
