################################################################################
#	Makefile settings for tms-fpga bitfile binary
################################################################################
#

# The main version
PROJECT		= TMS
GIT_URL 	= beam.beamnet:/data/git/Cern/tms
VERSION		= 1.3.0
RELEASE		= 1.beam
TARGET		?=
DIST		?=
PREFIX		?= /usr/tms

ifeq ("$(TARGET)", "")
TARGET			= $(shell cut -d " " -f1 /etc/bsystype.txt)
endif
ifeq ("$(DIST)", "")
DIST			= $(shell cut -d " " -f2 /etc/bsystype.txt)
endif

ifeq ("$(TARGET)", "")
$(error TARGET not defined)
endif

ifeq ("$(DIST)", "")
$(error DIST not defined)
endif

FPGADIR		= $(DEST_DIR)$(PREFIX)/fpga

all::

# TARGET Special Settings
ifeq ("$(TARGET)", "fedora")

# Build RPM packages
RPMBUILD_DIR	= ${HOME}/rpmbuild
DISTDIR_RELEASE	= /dist/cern/tms/${TARGET}_${DIST}

packages: clean package/rpm/tms-fpga.spec
	ln -sf tms-fpga-$(VERSION).bit tms-fpga.bit 
	rpmbuild --define "_topdir $(RPMBUILD_DIR)" --target noarch --build-in-place -bb package/rpm/tms-fpga.spec

packages-install:
	cp ${RPMBUILD_DIR}/RPMS/noarch/tms-fpga*.noarch.rpm ${DISTDIR_RELEASE}/packages
	createrepo ${DISTDIR_RELEASE}

.SUFFIXES: .spec

%.spec:	Config.mk
	@(if ! grep "^Version:.*${VERSION}" $@; then sed -i -e "s/^Version:.*/Version:\t${VERSION}/" $@; fi) 2>&1 > /dev/null
	@(if ! grep "^Release:.*${RELEASE}" $@; then sed -i -e "s/^Release:.*/Release:\t${RELEASE}%{dist}/" $@; fi) 2>&1 > /dev/null

else ifeq ("$(TARGET)", "debian")
# Build DEB packages
DEBBUILD_DIR	= /tmp/debbuild
DISTDIR_RELEASE	= /dist/cern/tms/${TARGET}_${DIST}

packages:
	-rm -fr ${DEBBUILD_DIR}
	-mkdir -p ${DEBBUILD_DIR}/tms-fpga
	cp -a * ${DEBBUILD_DIR}/tms-fpga
	cp -a ${DEBBUILD_DIR}/tms-fpga/package/debian ${DEBBUILD_DIR}/tms-fpga
	sed -i -e "s/tms-fpga (.*)/tms-fpga (${VERSION}-${RELEASE})/" ${DEBBUILD_DIR}/tms-fpga/debian/changelog
	(cd ${DEBBUILD_DIR}/tms-fpga; dpkg-buildpackage -us -uc -nc -b)
	#lintian ${DEBBUILD_DIR}/tms-fpga-${VERSION}${RELEASE}*.deb
	-rm -fr ${DEBBUILD_DIR}/tms-fpga

packages-install:
	mkdir -p ${DISTDIR_RELEASE}/pool/main
	cp ${DEBBUILD_DIR}/*.deb ${DISTDIR_RELEASE}/pool/main
	sh package/debian/createrepo.sh ${DISTDIR_RELEASE}

else
	$(error TARGET not defined)
endif
