################################################################################
#	Makefile settings for TMS systems packaging on Fedora systems
#	Copyright (c) 2024 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
################################################################################
#

TARGET_SYS	= linux
ARCH		?= $(shell arch)

BUILDDOC	= yes

SYSETCDIR	= $(DEST_DIR)/etc
SYSSYSTEMD	= $(DEST_DIR)/usr/lib/systemd
SYSDATADIR	= $(DEST_DIR)/data
BINDIR		= $(DEST_DIR)$(PREFIX)/bin
INCDIR		= $(DEST_DIR)$(PREFIX)/include
LIBDIR		= $(DEST_DIR)$(PREFIX)/${ARCH_LIB}
DATADIR		= $(DEST_DIR)${PREFIX}
DESKTOPDIR	= $(DEST_DIR)/usr/share/applications
DESKTOPDIRDIR	= $(DEST_DIR)/usr/share/desktop-directories
ICONSDIR	= $(DEST_DIR)/usr/share/icons

CONFDIR         = $(DEST_DIR)$(PREFIX)/config
DOCDIR		= $(DEST_DIR)$(PREFIX)/doc
HTMLDIR		= $(DEST_DIR)$(PREFIX)/html
STATETABLEDIR	= $(DEST_DIR)$(PREFIX)/stateTables
DATADIR		= $(DEST_DIR)$(PREFIX)/data
FPGADIR		= $(DEST_DIR)$(PREFIX)/fpga

ifeq ("${ARCH}","x86_64")
ARCH_LIB	= lib64
else
ARCH_LIB	= lib
endif

# QT
QTVER		= 5
QTDIR		= /usr/${ARCH_LIB}/qt5
QTINCDIR	= /usr/include/qt5
QTMOC		= $(QTDIR)/bin/moc
QTRCC		= /usr/bin/rcc
CXXFLAGS	+= -fPIC -I/usr/include/qt5/qwt -I${QTINCDIR} -I${QTINCDIR}/Qt -I${QTINCDIR}/QtGui -I${QTINCDIR}/QtWidgets -I${QTINCDIR}/QtCore -I${QTINCDIR}/QtHelp
LDLIBS_GUI	:= -lQt5Core -lQt5Gui -lQt5Widgets

.PRECIOUS: ${BUILDDIR}%_moc.cpp

${BUILDDIR}%_moc.cpp: %.h
	@echo "Creating moc $@ ..."
	#mkdir -p $(BUILDDIR)
	$(QTMOC) -o $@ $<


# Build RPM packages
RPMBUILD_DIR	= ${HOME}/rpmbuild
DISTDIR_RELEASE	= /dist/cern/tms/${TARGET}_${DIST}

all::

install-build-packages::
	dnf install bison flex fftw-devel pciutils-devel doxygen glibc-devel.i686 qt5-qtbase-devel

install-build-packages-latex::
	dnf install texlive-scheme-small texlive-multirow texlive-hanging texlive-listofitems texlive-ulem texlive-wasysym texlive-ec texlive-sectsty texlive-refman texlive-newunicodechar texlive-etoc

packages: rpms

packages-install: rpms-install

################################################################################
# RPM Software packages
################################################################################
#
rpms:
	rpmbuild --define "_topdir $(RPMBUILD_DIR)" --target ${ARCH} --build-in-place -bb package/rpm/tms.spec

rpms-install:
	cp ${RPMBUILD_DIR}/RPMS/${ARCH}/tms*-${VERSION}-${RELEASE}.${DIST}.${ARCH}.rpm ${DISTDIR_RELEASE}/packages
	cp ${RPMBUILD_DIR}/RPMS/noarch/tms-doc-${VERSION}-${RELEASE}.${DIST}.noarch.rpm ${DISTDIR_RELEASE}/packages
	createrepo ${DISTDIR_RELEASE}


.SUFFIXES: .spec

%.spec:	Config.mk
	@(if ! grep "^Version:.*${VERSION}" $@; then sed -i -e "s/^Version:.*/Version:\t${VERSION}/" $@; fi) 2>&1 > /dev/null
	@(if ! grep "^Release:.*${RELEASE}" $@; then sed -i -e "s/^Release:.*/Release:\t${RELEASE}%{dist}/" $@; fi) 2>&1 > /dev/null


