################################################################################
#	Makefile settings for TMS systems packaging on Debian systems
#	Copyright (c) 2024 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
################################################################################
#

TARGET_SYS	= linux
ARCH		?= $(shell arch)

BUILDDOC	= no

SYSETCDIR	= $(DEST_DIR)/etc
SYSSYSTEMD	= $(DEST_DIR)/usr/lib/systemd
SYSDATADIR	= $(DEST_DIR)/data
BINDIR		= $(DEST_DIR)$(PREFIX)/bin
INCDIR		= $(DEST_DIR)$(PREFIX)/include
LIBDIR		= $(DEST_DIR)$(PREFIX)/${ARCH_LIB}
DATADIR		= $(DEST_DIR)${PREFIX}
DESKTOPDIR	= $(DEST_DIR)/usr/share/applications
DESKTOPDIRDIR	= $(DEST_DIR)/usr/share/desktop-directories
ICONSDIR	= $(DEST_DIR)/usr/share/icons

CONFDIR         = $(DEST_DIR)$(PREFIX)/config
DOCDIR		= $(DEST_DIR)$(PREFIX)/doc
HTMLDIR		= $(DEST_DIR)$(PREFIX)/html
STATETABLEDIR	= $(DEST_DIR)$(PREFIX)/stateTables
DATADIR		= $(DEST_DIR)$(PREFIX)/data
FPGADIR		= $(DEST_DIR)$(PREFIX)/fpga


ifeq ("${ARCH}","x86_64")
ARCH_LIB	= lib64
else
ARCH_LIB	= lib
endif

# QT
QTVER		= 5
QTINCDIR	= /usr/include/x86_64-linux-gnu/qt5
QTMOC		= /usr/lib/qt5/bin/moc
QTRCC		= /usr/lib/qt5/bin/rcc
CXXFLAGS	+= -I/usr/include/qt5/qwt -I${QTINCDIR} -I${QTINCDIR}/Qt -I${QTINCDIR}/QtGui -I${QTINCDIR}/QtWidgets -I${QTINCDIR}/QtCore -I${QTINCDIR}/QtHelp
LDLIBS_GUI	:= -lQt5Core -lQt5Gui -lQt5Widgets

.PRECIOUS: ${BUILDDIR}%_moc.cpp

${BUILDDIR}%_moc.cpp: %.h
	@echo "Creating moc $@ ..."
	#mkdir -p $(BUILDDIR)
	$(QTMOC) -o $@ $<


# Build DEB packages
DEBBUILD_DIR	= /tmp/debbuild
DISTDIR_RELEASE	= /dist/cern/tms/${TARGET}_${DIST}

all::

install-build-packages::
	apt install build-essential bison flex qtbase5-dev libfftw3-dev libpci-dev dh-make lintian

packages: debs

packages-install: debs-install
	
	

################################################################################
# DEB Software packages
################################################################################
#
debs:
	-rm -fr ${DEBBUILD_DIR}
	-mkdir -p ${DEBBUILD_DIR}/tms
	cp -a Makefile Config.mk config tms tms-doc package/debian ${DEBBUILD_DIR}/tms
	sed -i -e "s/tms (.*)/tms (${VERSION}-${RELEASE})/" ${DEBBUILD_DIR}/tms/debian/changelog
	(cd ${DEBBUILD_DIR}/tms; dpkg-buildpackage -us -uc -nc -b)
	#lintian ${DEBBUILD_DIR}/tms-${VERSION}${RELEASE}*.deb
	-rm -fr ${DEBBUILD_DIR}/tms

debs-install:
	mkdir -p ${DISTDIR_RELEASE}/pool/main
	cp ${DEBBUILD_DIR}/*.deb ${DISTDIR_RELEASE}/pool/main
	sh package/debian/createrepo.sh ${DISTDIR_RELEASE}

setup:
	cp package/debian/tms-repo.list /etc/apt/sources.list.d
	apt update --allow-insecure-repositories
