/*******************************************************************************
 *	Pll.h		TMS State Table Pllerator
 *			T.Barnaby,	BEAM Ltd,	2007-03-15
 *******************************************************************************
 */

#ifndef Pll_h
#define Pll_h	1

#include <BError.h>
#include <BFile.h>
#include <BNameValue.h>
#include <SigGen.h>
#include <TmsLib.h>

using namespace Tms;

typedef BNameValue<BString>	Param;

class ParamList : public BNameValueList<BString> {
public:
	BString		getValue(BString name);
	void		setValue(BString name, BString value);
};


class Pll {
public:
				Pll();
				~Pll();
	
	BError			init(ParamList& params);
	BError			run();

protected:
	ParamList		oparams;

	BString			ofileName;
	double			osampleRate;
	double			ofref;
	CycleParam		ocycleParam;
};

#endif
