/*******************************************************************************
 *	Blr.cpp	Signal Blrerator classes
 *			T.Barnaby,	BEAM Ltd,	2006-09-12
 *******************************************************************************
 */

#include <Blr.h>
#include <BArray.h>
#include <math.h>


BString ParamList::getValue(BString name){
	BString*	s;
	
	if(s = find(name)){
		return *s;
	}
	return "";
}

void ParamList::setValue(BString name, BString value){
	BString*	s;
	
	if(s = find(name)){
		*s = value;
		return;
	}
	else {
		append(Param(name, value));
//		BList<BlrParam>::append(BlrParam(name, value));
	}
}

class Filter1 {
public:
		Filter1(){
			z0 = z1 = z2 = 0;
		}
		Int32	process(Int32 x){
			static double	a0 = 1.0, a1 = -1.991114292201654, a2 = 0.991153595868935;
			static double	b0 = 1.0, b1 = 2.0, b2 = 1.0;
			static double	g = 9.82592e-6;
			double		y;

			z0 = a0 * x - a1 * z1 - a2 * z2;
			y = z0 * b0+ z1 * b1 + z2 * b2;
			z2 = z1; 
			z1 = z0;

			return int(g * y);
		}
private:
		double	z0, z1, z2;
};

class Filter2 {
public:
		Filter2(){
			n1 = n2 = n3 = s4 = n4 = n5 = s6 = n6 = 0;
		}
	Int32	process(Int32 n1){
		n6 = n5 - s6;
		s6 = n5 - (n5 >> 10);
//		n5 = n4 + n5 - (n5 >> 8);	// FPGA
		n5 = n4 + n5 - (n5 >> 10);	// Matlab
		n4 = n3 - s4;
		s4 = n3 - (n3 >> 10);
		n3 = n2 + n3 - (n3 >> 8);
		n2 = n1 + n2 - (n2 >> 8);

//		return (n6 >> 7);
		return n6;
	}
private:
	Int32	n1;
	Int32	n2;
	Int32	n3;
	Int32	s4;
	Int32	n4;
	Int32	n5;
	Int32	s6;
	Int32	n6;
};

Blr::Blr(){
	osampleRate = 125000000.0;
	ofref = 437000.0;
}

Blr::~Blr(){
}

BError Blr::init(ParamList& params){
	BError		err;
	BString		s;
	CycleParamDb	cycleParams("../datasrc");
	
	oparams = params;
	
	if((s = params.getValue("fileName")) != "")
		ofileName = s;

	if((s = params.getValue("sampleRate")) != "")
		osampleRate = atof(s);

	if((s = params.getValue("fref")) != "")
		ofref = atof(s);

	cycleParams.getCycleParams("Beam3_0.spt", ocycleParam);
	
	return err;
}


#ifndef ZAP			
BError Blr::run(){
	BError		err;
	unsigned int	numSamples = 286;
	BArray<Sample>	sigma(numSamples);
	SigGenBeam	sigGenBeam;
	unsigned int	l;
	unsigned int	s;
	int		sin = 0;
	int		b0 = 0;
	int		e0 = 0;
	int		y0 = 0;
	int		x0 = 0;
	BFile		file("data.txt", "w");

	sigGenBeam.config(osampleRate, ofref, 8, 0x3C, 0, 0, 4096.0);

	for(l = 0; l < 100; l++){
		sigGenBeam.generate(sigma.data(), numSamples);
		
		for(s = 0; s < numSamples; s++){
			sin = int(sigma[s] * 1);

#ifdef ZAP
			// CERN Software algorithm, integer maths
			x0 = sin;
			y0 = (x0 - b0) + (e0 >> 7);
			e0 = e0 + x0;

			if(s < 8)
				b0 = b0 + (y0 >> 2);
#else
			// FPGA algorithm
//			if(s < 8)
//				b0 = b0 + (y0 >> 2);

			if(s < 32)
				b0 = b0 + (y0 >> 2);

			if(s > 240)
				b0 = b0 + (y0 >> 2);

			y0 = x0 + (e0 >> 7);
			e0 = e0 + x0;
			x0 = sin - b0;
//			printf("%d: %d %d %d\n", s, x0, sin, b0);
#endif
			file.printf("%d ", sin);
			file.printf("%d ", x0);
			file.printf("%d ", e0);
			file.printf("%d ", y0);
			file.printf("%d ", b0);
			file.printf("\n");
		}
	}

	return err;
}
#else
BError Blr::run(){
	BError		err;
	unsigned int	numSamples = 286;
	BArray<Sample>	sigma(numSamples);
	SigGenBeam	sigGenBeam;
	unsigned int	l;
	unsigned int	s;
	double		sin = 0;
	double		b0 = 0;
	double		e0 = 0;
	double		y0 = 0;
	double		x0 = 0;
	BFile		file("data.txt", "w");

	sigGenBeam.config(osampleRate, ofref, 8, 0x3C, 0, 0, 4096.0);

	for(l = 0; l < 100; l++){
		sigGenBeam.generate(sigma.data(), numSamples);
		
		for(s = 0; s < numSamples; s++){
			// CERN Software algorithm
			x0 = sin = int(sigma[s] * 1);

			y0 = (x0 - b0) + 0.01 * e0;
			e0 += x0;
			if(s < 8){
				b0 += 0.2 * y0;
			}

			file.printf("%f ", sin);
			file.printf("%f ", x0);
			file.printf("%f ", e0);
			file.printf("%f ", y0);
			file.printf("%f ", b0);
			file.printf("\n");
		}
	}

	return err;
}
#endif
