/*
** sysmon.c 
**
** Example for:
**
**   o ADM-XRC4LS
**   o ADM-XRC4LX
**   o ADM-XRC4SX
**   o ADM-XRC4FX
**   o ADM-XRC5LX
**   o ADM-XRC4FX
**   o ADM-XRC5LX
**   o ADM-XRC5T1
**   o ADPE-DEV
**
** (C) Copyright 2000-2006 Alpha Data Parallel Systems Ltd.
*/

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdint.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
typedef unsigned int DWORD;
typedef char BYTE;
#include <admxrc2.h>
#include <common.h>

#include "../common/common.h"


#undef ad_debug

#define SYSMONCTL    0x00400
#define SYSMONBUF    0x00500
#define SMB_ERROR    0x10000000


/*
 * Factors for LM87 values
 */
static float SysFactors[10] = {
   0.0130,
   0.0141,
   0.0172,
   0.0260,
   0.0625,
   0.0141,
   1.0000,
   1.0000,
   0.0098,
	0.0098
};


int main(int argc, char *argv[])
{
  int                ret = 0;
  ADMXRC2_STATUS     status;
  ADMXRC2_HANDLE     card = ADMXRC2_HANDLE_INVALID_VALUE;
  ADMXRC2_CARD_INFO  cardInfo;
  ADMXRC2_SPACE_INFO spInfo;
  volatile DWORD*    fpgaSpace;
  volatile DWORD*    ControlSpace;
  Option             options[2];
  Arguments          arguments;
  
  int                i;
  char*              SysMonBuf_ptr;
  int                SysVal;
  float              SysValue_arr[9];

  
  /* Set up expected options */
  options[0].key = "card";
  options[0].type = Option_uint;
  options[0].def.uintVal = 0;
  options[0].meaning = "ID of card to use";
  options[1].key = "index";
  options[1].type = Option_uint;
  options[1].def.uintVal = 0;
  options[1].meaning = "index of card to use";
  arguments.nOption = 2;
  arguments.option = options;
  arguments.nParamType = 0;
  arguments.minNParam = 0;

   /* Parse command line */
   parse_command_line(
      "read_controller",
      argc,
      argv,
      &arguments);

  if (options[0].specified && options[1].specified) {
    printf("Do not specify both /card and /index\n");
    ret = -1;
    goto done;
  }

  if (!options[1].specified) {
    ADMXRC2_CARDID cardID = options[0].value.uintVal;

    status = ADMXRC2_OpenCard(cardID, &card);
    if (status != ADMXRC2_SUCCESS) {
      printf("Failed to open card with ID %ld: %s\n",
        (unsigned long) cardID, ADMXRC2_GetStatusString(status));
      ret = -1;
      goto done;
    }
  } else {
    unsigned int index = options[1].value.uintVal;

    status = ADMXRC2_OpenCardByIndex(index, &card);
    if (status != ADMXRC2_SUCCESS) {
      printf("Failed to open card with index %ld: %s\n",
        (unsigned long) index, ADMXRC2_GetStatusString(status));
      ret = -1;
      goto done;
    }
  }


   status = ADMXRC2_GetCardInfo(card, &cardInfo);
   if (status != ADMXRC2_SUCCESS) {
      printf("Failed to get card info: %s\n", ADMXRC2_GetStatusString(status));
      ret = -1;
      goto done;
   }

   switch (cardInfo.BoardType) {
    case ADMXRC2_BOARD_ADMXRC4LX:
   case ADMXRC2_BOARD_ADMXRC4SX:
   case ADMXRC2_BOARD_ADMXRC4FX:
  	      break;

   default:
      printf("*** This example must be run on one of the following cards:\n\n");
        printf("\tADM-XRC4LX\n");
      printf("\tADM-XRC4SX\n");
      printf("\tADM-XRC4FX\n");
    		;
      ret = -1;
      goto done;
   }


   /* Get the address of FPGA space */
   status = ADMXRC2_GetSpaceInfo(card, 0, &spInfo);
   if (status != ADMXRC2_SUCCESS) {
      printf("Failed to get space 0 info: %s\n",
         ADMXRC2_GetStatusString(status));
      ret = -1;
      goto done;
   }

   fpgaSpace = (volatile DWORD*) spInfo.VirtualBase;



   /* Get the address of Control space */
   status = ADMXRC2_GetSpaceInfo(card, 1, &spInfo);
   if (status != ADMXRC2_SUCCESS) {
      printf("Failed to get space 0 info: %s\n",
         ADMXRC2_GetStatusString(status));
      ret = -1;
      goto done;
   }

   ControlSpace = (volatile DWORD*) spInfo.VirtualBase;




    printf ("\n\n*** SysMon ***\n\n");
   
   printf ("FPGA    Space Base Adr = %8.8x\n", fpgaSpace);
   printf ("Control Space Base Adr = %8.8x\n", ControlSpace);
   printf ("\n\n");
   
   switch (cardInfo.BoardType) {
       case ADMXRC2_BOARD_ADMXRC4LX:
      case ADMXRC2_BOARD_ADMXRC4SX:
         printf ("\nSpartan Control Build No.: %8.8x\n\n", ControlSpace[0]);
         break;
         
      default:
         break;
   }

      
   /* 
    * System Monitor Setup
    *
    * Reset the monitor              Adr:0x40, Da:0x80
    * Set the Fan1 & 2 i/p as AIN    Adr:0x16, Da:0x03
    * Switch on the power monitor    Adr:0x40, Da:0x01
    * Initiate a shadow read
    * 
    */
   switch (cardInfo.BoardType) {
         case ADMXRC2_BOARD_ADMXRC4LX:
      case ADMXRC2_BOARD_ADMXRC4SX:
		         ControlSpace[(SYSMONCTL / 4)] = 0x00034080;
         sleep(1);
         ControlSpace[(SYSMONCTL / 4)] = 0x00031603;
         sleep(1);
         ControlSpace[(SYSMONCTL / 4)] = 0x00034001;
         sleep(1);
         ControlSpace[(SYSMONCTL / 4)] = 0x00040000;
         sleep(1);
         break;
         
		case ADMXRC2_BOARD_ADMXRC4FX:
            
#if 1
         /*
          * Removed.  Bridge now sets up the LM87 Automatically
          */
         ControlSpace[(SYSMONCTL / 4)] = 0x132D4080;
         sleep(1);
         if (ControlSpace[(SYSMONCTL / 4)] & SMB_ERROR) {
            printf("\nSMB Serial Bus Error - LM87 Reset Failed\n");
            printf("Ctl = %8.8x\n", ControlSpace[(SYSMONCTL / 4)]);
            goto done;
         }
         ControlSpace[(SYSMONCTL / 4)] = 0x032D1603;
         sleep(1);
         ControlSpace[(SYSMONCTL / 4)] = 0x032D4001;
         sleep(1);
#endif      
         ControlSpace[(SYSMONCTL / 4)] = 0x042D0000;
         sleep(1);
         if (ControlSpace[(SYSMONCTL / 4)] & SMB_ERROR) {
            printf("\nSMB Serial Bus Error - Shadow Read Failed\n");
            goto done;
         }
         break;
      default:
         break;
   }

   /* Read the System Monitor readings */
   SysMonBuf_ptr =  (char *)ControlSpace + SYSMONBUF + 0x20;

   
   
   
	
	for (i=0; i<10; i++) {
		SysVal          = 0x000000FF & SysMonBuf_ptr[i];
		SysValue_arr[i] = (float) SysVal * SysFactors[i];
	}
   

	/*
	 * Print the outputs according to card type
	 */
	 
   switch (cardInfo.BoardType) {
	
		case ADMXRC2_BOARD_ADMXRC4LX:
		case ADMXRC2_BOARD_ADMXRC4SX:
			printf("+1V2 Reading = %4.2f V\n", SysValue_arr[8]);
			printf("+2V5 Reading = %4.2f V\n", SysValue_arr[0]);
			printf("+3V3 Reading = %4.2f V\n", SysValue_arr[2]);
			printf("+5V  Reading = %4.2f V\n", SysValue_arr[3]);
			printf("Vio  Reading = %4.2f V\n", SysValue_arr[4]);
			printf("FPIO Reading = %4.2f V\n", SysValue_arr[5]);
			printf("Pn4  Reading = %4.2f V\n", SysValue_arr[1]);
			printf("\n");
			printf("SysMon Int Temp = %4.0f deg. C \n", SysValue_arr[7]);
			printf("User FPGA Temp  = %4.0f deg. C \n", SysValue_arr[6]);
			break;
			
		case ADMXRC2_BOARD_ADMXRC4FX:
			printf("+1V2 Reading = %4.2f V\n", SysValue_arr[8]);
			printf("+1V5 Reading = %4.2f V\n", SysValue_arr[1]);
			printf("+1V8 Reading = %4.2f V\n", SysValue_arr[9]);
			printf("+2V5 Reading = %4.2f V\n", SysValue_arr[0]);
			printf("+3V3 Reading = %4.2f V\n", SysValue_arr[2]);
			printf("+5V  Reading = %4.2f V\n", SysValue_arr[3]);
			printf("Vio  Reading = %4.2f V\n", SysValue_arr[4]);
			printf("FPIO Reading = %4.2f V\n", SysValue_arr[5]);
			printf("\n");
			printf("SysMon Int Temp = %4.0f deg. C \n", SysValue_arr[7]);
			printf("User FPGA Temp  = %4.0f deg. C \n", SysValue_arr[6]);
			break;
			
			
		default:
      	printf("*** No valid readings for this card type. ***\n\n");
	}



done:
   printf("\n");
   
   ADMXRC2_CloseCard(card);
   
   return 0;
}
