/*******************************************************************************
 *	BEvent1.cpp	File Event class
 *			T.Barnaby,	BEAM Ltd,	2005-07-08
 *******************************************************************************
 */
#include	<stdlib.h>
#include	<unistd.h>
#include	<errno.h>
#include	<BEvent1.h>
#include	<BPoll.h>

BEvent1::BEvent1(uint32_t	type) : otype(type){
}

BEvent1::~BEvent1(){
}

uint32_t BEvent1::getType(){
	return otype;
}

BError BEvent1::getBinary(void* data, uint32_t& size){
	BError	err;
	
	memcpy(data, &otype, sizeof(otype));
	size = sizeof(otype);
	
	return err;
}

BError BEvent1::setBinary(void* data, uint32_t& size){
	BError	err;
	
	memcpy(&otype, data, sizeof(otype));
	size = sizeof(otype);
	
	return err;
}

BEvent1Error::BEvent1Error(int errNo, BString errStr) : BError(errNo, errStr), BEvent1(BEvent1TypeError){
}

BError BEvent1Error::getBinary(void* data, uint32_t& size){
	BError	err;
	char*	d = (char*)data;
	int	errNo;
	
	if(! (err = BEvent1::getBinary(data, size))){
		errNo = getErrorNo();
		memcpy(&d[size], &errNo, sizeof(errNo));
		size += sizeof(errNo);
		memcpy(&d[size], getString().retStr(), getString().len() + 1);
		size += getString().len() + 1;
	}
	
	return err;
}

BError BEvent1Error::setBinary(void* data, uint32_t& size){
	BError		err;
	char*		d = (char*)data;
	uint32_t&	s = size;
	int		errNo;
	
	if(! (err = BEvent1::setBinary(data, s))){
		memcpy(&errNo, &d[s], sizeof(errNo));
		s += sizeof(errNo);
		set(errNo, &d[s]);
		s += (getString().len() + 1);
		size = s;
	}
	
	return err;
}



BEvent1Pipe::BEvent1Pipe(){
	pipe(ofds);
}

BEvent1Pipe::~BEvent1Pipe(){
	close(ofds[0]);
	close(ofds[1]);
}


void BEvent1Pipe::clear(){
	BEvent1	e(BEvent1TypeNone);

	while(!getEvent(&e, 1));
}

BError BEvent1Pipe::sendEvent(BEvent1* event){
	BError		err;
	uint32_t	buffer[256];
	uint32_t	size = sizeof(buffer);
	
	err = event->getBinary(&buffer[1], size);
	buffer[0] = size;
	
	if(!err)
		write(ofds[1], buffer, 4 + size);
	
	return err;
}

BError BEvent1Pipe::getEvent(BEvent1* event, int timeOutUs){
	BError		err;
	uint32_t	buffer[256];
	uint32_t	size = sizeof(buffer);
	BPoll		poll;
	int		fd;
	
	if(timeOutUs >= 0){
		poll.append(ofds[0]);
		if(err = poll.doPoll(fd, timeOutUs))
			return err;
	}
	
	read(ofds[0], buffer, 4);
	size = buffer[0];
	read(ofds[0], &buffer[1], size);

	err = event->setBinary(&buffer[1], size);
	
	return err;
	
}

int BEvent1Pipe::getReceiveFd(){
	return ofds[0];
}

	
BEvent1Int::BEvent1Int(){
	pipe(ofds);
}

BEvent1Int::~BEvent1Int(){
	close(ofds[0]);
	close(ofds[1]);
}

void BEvent1Int::clear(){
	int	e;

	while(!getEvent(e, 1));
}

BError BEvent1Int::sendEvent(int event){
	BError	err;
	
	write(ofds[1], &event, sizeof(event));
	
	return err;
}

BError BEvent1Int::getEvent(int& event, int timeOutUs){
	BError		err;
	BPoll		poll;
	int		fd;
	
	if(timeOutUs >= 0){
		poll.append(ofds[0]);
		if(err = poll.doPoll(fd, timeOutUs))
			return err;
	}
		
	read(ofds[0], &event, sizeof(event));
	
	return err;
}

int BEvent1Int::getFd(){
	return ofds[0];
}
