/*******************************************************************************
 *	BDebug.h	Debug information and routines
 *			T.Barnaby,	BEAM Ltd,	2009-01-05
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BDebug_H
#define	BDebug_H

#include <stdio.h>
#include <syslog.h>
#include <time.h>

#define	BDebug_STD		0x000001

extern int	bdebug;

void hd8(void* data, unsigned int n);
void hd8a(void* data, unsigned int n);
void hda8(void* data, unsigned int n);
void hd32(void* data, unsigned int n);
void hds32(void* data, unsigned int n);
double getTime();
void setDebug(int debug);
void tprintf(int log, const char* fmt, ...);

pid_t gettid();

/// General debug functions
#if DEBUG
#define	dprintf(level, fmt, a...)       if((level) & bdebug) tprintf(1, fmt, ##a);
#else
#define	dprintf(level, fmt, a...)
#endif

/// Warnings and errors logging
#if DEBUG
#define	nprintf(fmt, a...)	{ syslog(LOG_NOTICE, fmt, ##a); if(BDebug_STD & bdebug) tprintf(0, fmt, ##a); }
#define	wprintf(fmt, a...)	{ syslog(LOG_WARNING, fmt, ##a); if(BDebug_STD & bdebug) tprintf(0, fmt, ##a); }
#define	eprintf(fmt, a...)	{ syslog(LOG_ERR, fmt, ##a); if(BDebug_STD & bdebug) tprintf(0, fmt, ##a); }
#else
#define	nprintf(fmt, a...)	syslog(LOG_NOTICE, fmt, ##a)
#define	wprintf(fmt, a...)	syslog(LOG_WARNING, fmt, ##a)
#define	eprintf(fmt, a...)	syslog(LOG_ERR, fmt, ##a)
#endif

class BDebugBacktrace {
public:
			BDebugBacktrace();
			~BDebugBacktrace();

	void		dumpBacktraceStdout(char* comment);
	int		dumpBacktraceFile(char* fileName, char* comment);
	void		dumpBacktraceSyslog(char* comment);
	void		dumpBacktrace(char* strBuf, int strBufLen, char* comment);
private:
};

#endif
