/*******************************************************************************
 *	GenBoapPhp.cc	BEAM Data output
 *			T.Barnaby,	BEAM Ltd,	12/9/03
 *******************************************************************************
 */
#define	DEBUG	1

#include <stdio.h>
#include <stdarg.h>
#include <strings.h>
#include <GenBoapPhp.h>
#include <bidl.h>

BString GenBoapPhp::getTypeNamePhp(Node* n, int data){
	BString	typeName;
	
	if(n->nodeType() == Node::TTYPELIST){
		return BString("array");
	}
	else if(n->nodeType() == Node::TTYPEARRAY){
		return BString("array");
	}
	else if(n->nodeType() == Node::TTYPEDICT){
		return BString("array");
	}
	else {
		typeName = n->name();
		if(typeName == "Int32")		return "long";
		else if(typeName == "UInt32")	return "long";
		else if(typeName == "Int16")	return "long";
		else if(typeName == "UInt16")	return "long";
		else if(typeName == "Int8")	return "long";
		else if(typeName == "UInt8")	return "long";
		else if(typeName == "Int64")	return "long";
		else if(typeName == "UInt64")	return "long";
		else if(typeName == "Float32")	return "double";
		else if(typeName == "Float64")	return "double";
		else if(typeName == "Bool")	return "bool";
		else if(typeName == "String")	return "string";
		else if(typeName == "Error")	return "BBError";
		else if(typeName == "TimeStamp")return "DateTime";
		else if(typeName == "Complex")	return "BComplex";
		else return typeName;
	}
}

BString GenBoapPhp::getTypeSwapList(Node* n){
	BString	typeName;
	Type*	t;
	BIter	i;
	BString	typeList;

	typeName = n->name();
//	printf("isRawType: %d %s\n", n->nodeType(), typeName.retStr());

	if(n->nodeType() == Node::TTYPEARRAY){
		return "";
	}
	else if(n->nodeType() == Node::TTYPEDICT){
		return "";
	}
	else if(n->nodeType() == Node::TTYPE){
		if(typeName == "Int8")		return "1";
		else if(typeName == "UInt8")	return "1";
		else if(typeName == "Int16")	return "2";
		else if(typeName == "UInt16")	return "2";
		else if(typeName == "Int32")	return "4";
		else if(typeName == "UInt32")	return "4";
		else if(typeName == "Bool")	return "4";
		else if(typeName == "String")	return "";
		else if(typeName == "Error")	return "";
		else if(typeName == "Date")	return "";
		else if(typeName == "DateTime")	return "";
		else if(typeName == "Id")	return "";
		else if(typeName == "ObjData")	return "";
		else if(typeName == "TimeStamp")	return "";
		else if(typeName == "Complex")	return "";
		else {
			if(t = gtypelist.search(typeName)){
				if(t->node()){
					return  getTypeSwapList(t->node());
				}
			}
			else
				return "";
		}
	}
	else if(n->nodes().number()){
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			typeList += getTypeSwapList(n->nodes()[i]);
		}

		return typeList;
	}
	return "";
}


void GenBoapPhp::produceImp(Node* n){
	BString		s;
	BString		t;
	BIter		i;
	BList<Node*>*	nl;
	BString		typeName;
	BString		typeNamePhp;
	BString		line;
	BString		str;
	
	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = n->name();

		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImp(n->nodes()[i]);
		}
		break;
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImp(n->nodes()[i]);
		}
		break;

	case Node::TENUM:
		// Add convertors
		oconvertors.writeLine(BString("static BError convert(zval* v, ") + omodule + "::" + n->node(0)->name() + "& r){\n");
		oconvertors.indentMore();
		oconvertors.writeLine("BError err;\n");
		oconvertors.printf("r = (%s)Z_LVAL_P(v);\n", (omodule + "::" + n->node(0)->name()).retStr());
		oconvertors.writeLine("return err;\n");
		oconvertors.indentLess();
		oconvertors.writeLine("}\n\n");
		break;

	case Node::TSTRUCT:
		if(n->name() == "BObj")
			return;

		typeName = omodule + "::" + n->name();
		typeNamePhp = omodule + n->name();
		ofileImp.writeLine(BString("// ") + typeName + " Object Implementation\n");
		
		ofileImp.printf("zend_class_entry*	%s_class;\n\n", typeNamePhp.lowerFirst().retStr());
		
		if((n->nodes().number() == 2) && n->node(1)){
			ofileImp.writeLine(BString("PHP_METHOD(") + typeNamePhp + ", __construct){\n");
		}
		else {
			ofileImp.writeLine(BString("PHP_METHOD(") + typeNamePhp + ", __construct){\n");
		}

		ofileImp.indentMore();
		ofileImp.writeLine("zval	v;\n");

		nl = &n->node(0)->nodes();
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			t = getTypeNamePhp(nl->get(i)->node(0), 1);
			s = nl->get(i)->node(1)->name();
			if(t == "long")
				line = BString("objSet(getThis(), \"") + s + "\", 0);\n";
			else if(t == "double")
				line = BString("objSet(getThis(), \"") + s + "\", 0.0);\n";
			else if(t == "bool")
				line = BString("objSet(getThis(), \"") + s + "\", false);\n";
			else if(t == "string")
				line = BString("objSet(getThis(), \"") + s + "\", \"\");\n";
			else if(t == "DateTime")
				line = BString("objSet(getThis(), \"") + s + "\", BTimeStamp());\n";
			else if(t == "array"){
				ofileImp.writeLine("array_init(&v);\n");
				line = BString("zend_update_property(NULL, getThis(), \"") + s + "\", strlen(\"" + s + "\"), &v TSRMLS_CC);\n";
			}
			else
				line =BString("objSet(getThis(), \"") + s + "\", " + omodule + "::" + getTypeName(nl->get(i)->node(0), 1) + "());\n";

#ifdef ZAP
    pThis = getThis();

    MAKE_STD_ZVAL(myarray);
    array_init(myarray);
    zend_declare_property(Z_OBJCE_P(pThis), "MyMemberArray", sizeof("MyMemberArray"), myarray, ZEND_ACC_PUBLIC TSRMLS_DC);
#endif

			ofileImp.writeLine(line);
		}
		ofileImp.indentLess();
		ofileImp.writeLine("}\n\n");
		
		ofileImp.writeLine(BString("zend_function_entry ") + typeNamePhp + "Methods[] = {\n");
		ofileImp.indentMore();
		ofileImp.writeLine(BString("PHP_ME(") + typeNamePhp + ",  __construct, NULL, ZEND_ACC_PUBLIC | ZEND_ACC_CTOR)\n");
		ofileImp.writeLine("{NULL, NULL, NULL}\n");
		ofileImp.indentLess();
		ofileImp.writeLine("};\n\n");

		// Add convertors
		oconvertors.writeLine(BString("BError convert(zval* v, ") + typeName + "& r){\n");
		oconvertors.indentMore();
		oconvertors.writeLine("BError err;\n");

		nl = &n->node(0)->nodes();
		if(nl->number()){
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				t = getTypeNamePhp(nl->get(i)->node(0), 1);
				s = nl->get(i)->node(1)->name();
				oconvertors.writeLine(BString("convert(objGet(v, \"") + s + "\"), r." + s + ");\n");
			}
		}
		oconvertors.writeLine("return err;\n");
		oconvertors.indentLess();
		oconvertors.writeLine("}\n\n");

		oconvertors.writeLine(BString("BError convert(const ") + typeName + "& v, zval* r){\n");
		oconvertors.indentMore();
		oconvertors.writeLine("BError err;\n\n");
		oconvertors.printf("object_init_ex(r, %s_class);\n", typeNamePhp.lowerFirst().retStr());

		nl = &n->node(0)->nodes();
		if(nl->number()){
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				t = getTypeNamePhp(nl->get(i)->node(0), 1);
				s = nl->get(i)->node(1)->name();
				oconvertors.writeLine(BString("objSet(r, \"") + s + "\", v." + s + ");\n");
			}
		}
		oconvertors.writeLine("return err;\n");
		oconvertors.indentLess();
		oconvertors.writeLine("}\n\n");

		oconvertors.writeLine(BString("void objSet(zval* pv, const char* name, const ") + typeName + "& cv){\n");
		oconvertors.indentMore();
		oconvertors.writeLine("zval	v;\n\n");
		oconvertors.printf("object_init_ex(&v, %s_class);\n", typeNamePhp.lowerFirst().retStr());

		nl = &n->node(0)->nodes();
		if(nl->number()){
			for(nl->start(i); !nl->isEnd(i); nl->next(i)){
				t = getTypeNamePhp(nl->get(i)->node(0), 1);
				s = nl->get(i)->node(1)->name();
				oconvertors.writeLine(BString("objSet(&v, \"") + s + "\", cv." + s + ");\n");
			}
		}
		oconvertors.writeLine("objSet(pv, name, &v);\n");
		oconvertors.indentLess();
		oconvertors.writeLine("}\n\n");
		ofileImp.writeString(oconvertors);
		oconvertors.clear();

		oclasses.append(typeNamePhp);
		break;

	case Node::TINTERFACE:
		ointerface = omodule + "::" + n->name();
		ointerfacePhp = omodule + n->name();
		oclasses.append(ointerfacePhp);
		ointerfaces.append(ointerfacePhp);

		ofuncNum = 16;
		
		ofileImp.printf("zend_class_entry*	%s_class;\n", ointerfacePhp.lowerFirst().retStr());
		
		// Temporary object access
//		ofileImp.printf("%s* %s;\n\n", ointerface.retStr(), ointerfacePhp.lowerFirst().retStr());
		
		// Wrapper object code
		ofileImp.printf("zend_object_handlers	%s_handlers;\n\n", ointerfacePhp.lowerFirst().retStr());

		ofileImp.printf("static zend_object* %sCreate(zend_class_entry* ce){\n", ointerfacePhp.lowerFirst().retStr());
		ofileImp.indentMore();
		ofileImp.printf("WrapObj*	obj;\n\n");
		ofileImp.printf("obj = (WrapObj*)ecalloc(1, sizeof(WrapObj) + zend_object_properties_size(ce));\n");
		ofileImp.printf("obj->cobj = 0;\n");
		ofileImp.printf("zend_object_std_init(&obj->zobj, ce);\n");
		ofileImp.printf("object_properties_init(&obj->zobj, ce);\n");
		ofileImp.printf("obj->zobj.handlers = &%s_handlers;\n", ointerfacePhp.lowerFirst().retStr());
		ofileImp.printf("return &obj->zobj;\n");
		ofileImp.indentLess();
		ofileImp.printf("}\n\n");

		ofileImp.printf("static void %sDestroy(zend_object* object){\n", ointerfacePhp.lowerFirst().retStr());
		ofileImp.indentMore();
		ofileImp.printf("%s*	obj = (%s*)(((WrapObj*)((char*)object - offsetof(WrapObj, zobj)))->cobj);\n", ointerface.retStr(), ointerface.retStr());
		ofileImp.printf("delete obj;\n");
		ofileImp.printf("zend_objects_destroy_object(object);\n");
		ofileImp.indentLess();
		ofileImp.printf("}\n\n");

		ofileImp.printf("static void %sFree(zend_object* object){\n", ointerfacePhp.lowerFirst().retStr());
		ofileImp.indentMore();
		ofileImp.printf("WrapObj*	obj = (WrapObj*)((char*)object - offsetof(WrapObj, zobj));\n\n");
		ofileImp.printf("zend_object_std_dtor(object);\n");
		ofileImp.printf("efree(obj);\n");
		ofileImp.indentLess();
		ofileImp.printf("}\n\n");

		ofileImp.printf("PHP_METHOD(%s, __construct){\n", ointerfacePhp.retStr());
		ofileImp.indentMore();
		ofileImp.printf("WrapObj*	obj = (WrapObj*)((char*)Z_OBJ_P(getThis()) - offsetof(WrapObj, zobj));\n\n");
		ofileImp.printf("obj->cobj = new %s();\n", ointerface.retStr());
		
//		ofileImp.printf("if(%s) delete %s;\n", ointerfacePhp.lowerFirst().retStr(), ointerfacePhp.lowerFirst().retStr());
//		ofileImp.printf("%s = new %s();\n", ointerfacePhp.lowerFirst().retStr(), ointerface.retStr());
		ofileImp.indentLess();
		ofileImp.printf("}\n\n");

		ofileImp.printf("PHP_METHOD(%s, connectService){\n", ointerfacePhp.retStr());
		ofileImp.indentMore();
		ofileImp.printf("BError			err;\n");
		ofileImp.printf("%s*	obj = (%s*)(((WrapObj*)((char*)Z_OBJ_P(getThis()) - offsetof(WrapObj, zobj)))->cobj);\n", ointerface.retStr(), ointerface.retStr());
		ofileImp.printf("char*			name = 0;\n");
		ofileImp.printf("long			nameLen;\n\n");
		ofileImp.printf("if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, \"s\", &name, &nameLen) == FAILURE)\n");
		ofileImp.printf("\tRETURN_NULL();\n\n");
		ofileImp.printf("err = obj->connectService(name);\n");
		ofileImp.printf("convert(err, return_value);\n");
		ofileImp.indentLess();
		ofileImp.printf("}\n\n");

		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImp(n->nodes()[i]);
		}
		
		ofileImp.writeLine(str.printf("zend_function_entry %sMethods[] = {\n", ointerfacePhp.retStr()));
		ofileImp.indentMore();
		ofileImp.writeLine(str.printf("PHP_ME(%s,\t__construct,     NULL, ZEND_ACC_PUBLIC | ZEND_ACC_CTOR)\n", ointerfacePhp.retStr()));
		ofileImp.writeLine(str.printf("PHP_ME(%s,\tconnectService,     NULL, ZEND_ACC_PUBLIC)\n", ointerfacePhp.retStr()));

		BListLoop(oclassFunctions, i1){
			ofileImp.writeLine(str.printf("PHP_ME(%s,\t%s,\t%s_%s_args, ZEND_ACC_PUBLIC)\n", ointerfacePhp.retStr(), oclassFunctions[i1].retStr(), ointerfacePhp.retStr(), oclassFunctions[i1].retStr()));
		}
		ofileImp.writeLine("{NULL, NULL, NULL}\n");

		ofileImp.indentLess();
		ofileImp.writeLine("};\n\n");
		oclassFunctions.clear();
		break;
		
	case Node::TFUNC:
		oclassFunctions.append(n->name());
		
		// Convert input args
		nl = &n->node(1)->nodes();
		ofileImp.printf("ZEND_BEGIN_ARG_INFO_EX(%s_%s_args, 0, 0, 0)\n", ointerfacePhp.retStr(), n->name().retStr());
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			if((nl->get(i)->node(0)->name() == "out") || (nl->get(i)->node(0)->name() == "inout")){
				ofileImp.printf("ZEND_ARG_INFO(1, %s)\n", nl->get(i)->node(2)->name().retStr());
			}
			else {
				ofileImp.printf("ZEND_ARG_INFO(0, %s)\n", nl->get(i)->node(2)->name().retStr());
			}
		}
		ofileImp.printf("ZEND_END_ARG_INFO()\n\n");

		ofileImp.writeLine(str.printf("PHP_METHOD(%s, %s){\n", ointerfacePhp.retStr(), n->name().retStr()));
		ofileImp.indentMore();
		produceFunc(n);
		ofileImp.indentLess();
		ofileImp.writeLine("}\n\n");
		ofuncNum++;
		break;

	default:
		break;
	}
}

void GenBoapPhp::produceFunc(Node* n){
	BIter		i;
	BString		s;
	BList<Node*>*	nl;
	BString		retType;
	int		c;
	
	retType = getTypeName(n->node(0));
	
	ofileImp.printf("%s*	obj = (%s*)(((WrapObj*)((char*)Z_OBJ_P(getThis()) - offsetof(WrapObj, zobj)))->cobj);\n", ointerface.retStr(), ointerface.retStr());
//	ofileImp.printf("%s*\tobj = %s;\n", ointerface.retStr(), ointerfacePhp.lowerFirst().retStr());
	ofileImp.writeLine(retType + "\t\tret;\n");
	
	// Add local variables for function arguments
	nl = &n->node(1)->nodes();
	for(nl->start(i), c = 0; !nl->isEnd(i); nl->next(i)){
		ofileImp.writeLine(getTypeName(nl->get(i)->node(1), 0) + "\t\tcarg_" + nl->get(i)->node(2)->name() + ";\n");
		c++;
	}
	
	// Input arguments
	ofileImp.printf("zval\t\targs[ZEND_NUM_ARGS()];\n\n");
	ofileImp.printf("zend_get_parameters_array_ex(ZEND_NUM_ARGS(), args);\n");
	ofileImp.printf("\n");

	// Convert input args
	for(nl->start(i), c = 0; !nl->isEnd(i); nl->next(i)){
		if((nl->get(i)->node(0)->name() == "in") || (nl->get(i)->node(0)->name() == "inout")){
			ofileImp.printf("// convert to type: %s %d\n", nl->get(i)->node(1)->name().retStr(), nl->get(i)->node(1)->nodeType());
			ofileImp.printf("convert(&args[%d], carg_%s);\n", c, nl->get(i)->node(2)->name().retStr());
		}
		c++;
	}
	ofileImp.writeLine("\n");

	ofileImp.writeLine("// CallFunc\n");
	s = s + "ret = ";
	s = s + "obj->";
	s = s + n->name() + "(";
	nl = &n->node(1)->nodes();
	for(nl->start(i); !nl->isEnd(i); nl->next(i)){
		if(i != nl->begin())
			s = s + ", ";
		s = s + "carg_" + nl->get(i)->node(2)->name();
	}
	s = s + ");\n";
	ofileImp.writeLine(s);
	ofileImp.writeLine("\n");

	// Return via referenaces
	nl = &n->node(1)->nodes();
	for(nl->start(i), c = 0; !nl->isEnd(i); nl->next(i), c++){
		if((nl->get(i)->node(0)->name() == "out") || (nl->get(i)->node(0)->name() == "inout")){
			ofileImp.printf("convert(carg_%s,  Z_REFVAL_P(&args[%d]));\n", nl->get(i)->node(2)->name().retStr(), c);
		}
	}
	ofileImp.writeLine("convert(ret,  return_value);\n");
}

#if OLD_GXX
static const char*	headerFunctions = "warning \"Not supported\"";
#else
static const char*	headerFunctions = R"(

// Base classes
static zend_class_entry*	berror_class;
static zend_class_entry*	bcomplex_class;

// Object member access functions
static long objGetLong(zval* obj, const char* name){
	zval*	v;

	v = zend_read_property(Z_OBJCE_P(obj), obj, name, strlen(name), 0, 0 TSRMLS_CC);
	return Z_LVAL_P(v);
}

static long objGetDouble(zval* obj, const char* name){
	zval*	v;

	v = zend_read_property(Z_OBJCE_P(obj), obj, name, strlen(name), 0, 0 TSRMLS_CC);
	return Z_DVAL_P(v);
}

static const char* objGetString(zval* obj, const char* name){
	zval*	v;

	v = zend_read_property(Z_OBJCE_P(obj), obj, name, strlen(name), 0, 0 TSRMLS_CC);
	return Z_STRVAL_P(v);
}

static zval* objGet(zval* obj, const char* name){
	return zend_read_property(Z_OBJCE_P(obj), obj, name, strlen(name), 0, 0 TSRMLS_CC);
}

// Object member set functions
static void objSet(zval* obj, const char* name, zval* v){
	zend_update_property(NULL, obj, name, strlen(name), v TSRMLS_CC);
}

static void objSet(zval* obj, const char* name, BUInt32 v){
	zend_update_property_long(NULL, obj, name, strlen(name), v TSRMLS_CC);
}

static void objSet(zval* obj, const char* name, BInt32 v){
	zend_update_property_long(NULL, obj, name, strlen(name), v TSRMLS_CC);
}

static void objSet(zval* obj, const char* name, BInt64 v){
	zend_update_property_long(NULL, obj, name, strlen(name), v TSRMLS_CC);
}

static void objSet(zval* obj, const char* name, BUInt64 v){
	zend_update_property_long(NULL, obj, name, strlen(name), v TSRMLS_CC);
}

static void objSet(zval* obj, const char* name, BFloat64 v){
	zend_update_property_double(NULL, obj, name, strlen(name), v TSRMLS_CC);
}

static void objSet(zval* obj, const char* name, const BString& v){
	zend_update_property_string(NULL, obj, name, strlen(name), v.retStr() TSRMLS_CC);
}

static void objSet(zval* obj, const char* name, const BError& v){
	zval	z;

	object_init_ex(&z, berror_class);
	objSet(&z, "num", v.num());
	objSet(&z, "str", v.getString());
	objSet(obj, name, &z);
}

static void objSet(zval* obj, const char* name, const BTimeStamp& v){
	zend_string*		className = zend_string_init("DateTime", strlen("DateTime"), 0);
	zend_class_entry*	ce;
	zval			z;
	zval			ret, constructor;
	zval			dateTimeStr;

	ce = zend_lookup_class(className);

	object_init_ex(&z, ce);

	// Call constructors with appropriate arguments
	ZVAL_STRING(&constructor, ZEND_CONSTRUCTOR_FUNC_NAME);
	ZVAL_STRING(&dateTimeStr, strdup(v.getString().retStr()));

	if(call_user_function(NULL, &z, &constructor, &ret, 1, &dateTimeStr) == FAILURE){
		php_error_docref(NULL, E_ERROR, "Error calling constructor");
	}
	zval_dtor(&constructor);
	zval_dtor(&ret);
	zval_dtor(&dateTimeStr);
	objSet(obj, name, &z);
}

static void objSet(zval* obj, const char* name, const BComplex& v){
	zval	z;

	object_init_ex(&z, bcomplex_class);
	objSet(&z, "real", v.real());
	objSet(&z, "imag", v.imag());
	objSet(obj, name, &z);
}


// Convertor functions to PHP
static void convert(const BInt32& cv, zval* pv){
	ZVAL_LONG(pv, cv);
}

static void convert(const BUInt32& cv, zval* pv){
	ZVAL_LONG(pv, cv);
}

static void convert(const BInt64& cv, zval* pv){
	ZVAL_LONG(pv, cv);
}

static void convert(const BUInt64& cv, zval* pv){
	ZVAL_LONG(pv, cv);
}

static void convert(const BFloat64& cv, zval* pv){
	ZVAL_DOUBLE(pv, cv);
}

static void convert(const BString& cv, zval* pv){
	ZVAL_STRING(pv, cv);
}

static void convert(const BComplex& cv, zval* pv){
	object_init_ex(pv, bcomplex_class);
	objSet(pv, "real", cv.real());
	objSet(pv, "imag", cv.imag());
}

static void convert(const BError& cv, zval* pv){
	object_init_ex(pv, berror_class);
	objSet(pv, "num", cv.num());
	objSet(pv, "str", cv.getString());
}



// Convertor functions to C++
static void convert(zval* pv, BUInt8& cv){
	cv = Z_LVAL_P(pv);
}

static void convert(zval* pv, BInt32& cv){
	cv = Z_LVAL_P(pv);
}

static void convert(zval* pv, BUInt32& cv){
	cv = Z_LVAL_P(pv);
}

static void convert(zval* pv, BInt64& cv){
	cv = Z_LVAL_P(pv);
}

static void convert(zval* pv, BUInt64& cv){
	cv = Z_LVAL_P(pv);
}

static void convert(zval* pv, BFloat64& cv){
	cv = Z_DVAL_P(pv);
}

static void convert(zval* pv, BString& cv){
	cv = Z_STRVAL_P(pv);
}

static void convert(zval* pv, BError& cv){
	cv.set(objGetLong(pv, "num"), objGetString(pv, "str"));
}

static void convert(zval* pv, BTimeStamp& cv){
	zval			dateTimeStr, function, ret;

	// Call constructors with appropriate arguments
	ZVAL_STRING(&dateTimeStr, "Y-m-d H:i:s.u'");
	ZVAL_STRING(&function, "format");

	if(call_user_function(NULL, pv, &function, &ret, 1, &dateTimeStr) == FAILURE){
		php_error_docref(NULL, E_ERROR, "Error calling format");
	}
	
//	printf("SetDateTime: %s\n", Z_STRVAL(ret));
	cv.setString(Z_STRVAL(ret));

	zval_dtor(&ret);
	zval_dtor(&function);
	zval_dtor(&dateTimeStr);
}

static void convert(zval* pv, BComplex& cv){
	cv = BComplex(objGetDouble(pv, "real"), objGetDouble(pv, "imag"));
}


// Array, List and Dictionaly convertors and member setters
template <class T> static void convert(zval* pv, BArray<T>& cv){
	HashTable*	ah;
	HashPosition	ap;
	zval*		vp;
	T		vc;

	ah = Z_ARRVAL_P(pv);
	cv.clear();
	for(zend_hash_internal_pointer_reset_ex(ah, &ap); vp = zend_hash_get_current_data_ex(ah, &ap); zend_hash_move_forward_ex(ah, &ap)){
		convert(vp, vc);
		cv.append(vc);
	}
}

template <class T> static void convert(const BArray<T>& cv, zval* obj){
	zval		vp;
	BUInt		i;

	array_init(obj);
	for(i = 0; i < cv.number(); i++){
		convert(cv[i], &vp);
		add_next_index_zval(obj, &vp);
	}
}

template <class T> static void objSet(zval* obj, const char* name, const BArray<T>& cv){
	zval	a;
	
	convert(cv, &a);
	objSet(obj, name, &a);
}


template <class T> static void convert(zval* pv, BList<T>& cv){
	HashTable*	ah;
	HashPosition	ap;
	zval*		vp;
	T		vc;

	ah = Z_ARRVAL_P(pv);
	cv.clear();
	for(zend_hash_internal_pointer_reset_ex(ah, &ap); vp = zend_hash_get_current_data_ex(ah, &ap); zend_hash_move_forward_ex(ah, &ap)){
		convert(vp, vc);
		cv.append(vc);
	}
}

template <class T> static void convert(const BList<T>& cv, zval* obj){
	zval		vp;

	array_init(obj);
	BListLoop(cv, i){
		convert(cv[i], &vp);
		add_next_index_zval(obj, &vp);
	}
}

template <class T> static void objSet(zval* obj, const char* name, const BList<T>& cv){
	zval	a;
	
	convert(cv, &a);
	objSet(obj, name, &a);
}


template <class T> static void convert(zval* pv, BDict<T>& cv){
	HashTable*	ah;
	HashPosition	ap;
	zval*		vp;
	T		vc;
	zend_string*	key;
	zend_ulong	keyLen;

	ah = Z_ARRVAL_P(pv);
	cv.clear();
	for(zend_hash_internal_pointer_reset_ex(ah, &ap); vp = zend_hash_get_current_data_ex(ah, &ap); zend_hash_move_forward_ex(ah, &ap)){
		zend_hash_get_current_key_ex(ah, &key, &keyLen, &ap);
		convert(vp, vc);
		cv[key->val] = vc;
	}
}

template <class T> static void convert(const BDict<T>& cv, zval* obj){
	HashTable*	ah;
	zval		vp;
	zend_string*	key;

	array_init(obj);
	ah = Z_ARRVAL_P(obj);

	BListLoop(cv, i){
		convert(cv[i], &vp);
		key = zend_string_init(cv.key(i), cv.key(i).len(), 0);
		zend_hash_add(ah, key, &vp);
	}
}

template <class T> static void objSet(zval* obj, const char* name, const BDict<T>& cv){
	zval	a;

	convert(cv, &a);
	objSet(obj, name, &a);
}


// Base classes
PHP_METHOD(BBError, __construct){
	objSet(getThis(), "num", 0);
	objSet(getThis(), "str", "");
}

zend_function_entry BBErrorMethods[] = {
	PHP_ME(BBError,  __construct, NULL, ZEND_ACC_PUBLIC | ZEND_ACC_CTOR)
	{NULL, NULL, NULL}
};


PHP_METHOD(BComplex, __construct){
	objSet(getThis(), "real", 0.0);
	objSet(getThis(), "imag", 0.0);
}

zend_function_entry BComplexMethods[] = {
	PHP_ME(BComplex,  __construct, NULL, ZEND_ACC_PUBLIC | ZEND_ACC_CTOR)
	{NULL, NULL, NULL}
};

// C++ classes wrapper
typedef struct {
	void*		cobj;
	zend_object     zobj;
} WrapObj;

)";
#endif

BError GenBoapPhp::produceHeaderImp(){
	BError	err;

	ofileImp.printf("/*****************************************************************************\n");
	ofileImp.printf(" *\t%s\tProduced by Bidl\n", (ofileName + ".cpp").retStr());
	ofileImp.printf(" *****************************************************************************\n");
	ofileImp.printf(" */\n");
	ofileImp.printf("#include<BTypes.h>\n");
	ofileImp.printf("#include<BString.h>\n");
	ofileImp.printf("#include<BError.h>\n");
	ofileImp.printf("#include<php.h>\n");
	ofileImp.printf("#include<php.h>\n");
	ofileImp.printf("\n");
	ofileImp.printf("#include<%sD.h>\n", ofileName.retStr());
	ofileImp.printf("#include<%sC.h>\n", ofileName.retStr());
	ofileImp.printf("\n");
	ofileImp.printf("using namespace %s;\n", ofileName.retStr());

	ofileImp.writeLine(headerFunctions);
	
	
	return err;
}

BError GenBoapPhp::produceTrailerImp(){
	BError	err;
	BString	str;
	
	ofileImp.writeLine(str.printf("PHP_MINIT_FUNCTION(%s){\n", ofileName.retStr()));
	ofileImp.indentMore();

	ofileImp.writeLine("zend_class_entry	ce;\n\n");

	ofileImp.printf("INIT_CLASS_ENTRY(ce, \"BBError\", BBErrorMethods)\n");
	ofileImp.printf("berror_class = zend_register_internal_class(&ce TSRMLS_CC);\n\n");
	ofileImp.printf("INIT_CLASS_ENTRY(ce, \"BComplex\", BComplexMethods)\n");
	ofileImp.printf("bcomplex_class = zend_register_internal_class(&ce TSRMLS_CC);\n\n");

	BListLoop(oclasses, i){
		const char*	typeName = oclasses[i].retStr();
		ofileImp.printf("INIT_CLASS_ENTRY(ce, \"%s\", %sMethods)\n", typeName, typeName);
		ofileImp.printf("%s_class = zend_register_internal_class(&ce TSRMLS_CC);\n\n", oclasses[i].lowerFirst().retStr());
	}

	BListLoop(ointerfaces, i){
		// Wrap object handling
		ofileImp.printf("%s_class->create_object = %sCreate;\n", oclasses[i].lowerFirst().retStr(), oclasses[i].lowerFirst().retStr());
		ofileImp.printf("memcpy(&%s_handlers, zend_get_std_object_handlers(), sizeof(%s_handlers));\n", oclasses[i].lowerFirst().retStr(), oclasses[i].lowerFirst().retStr());
		ofileImp.printf("%s_handlers.dtor_obj = %sDestroy;\n", oclasses[i].lowerFirst().retStr(), oclasses[i].lowerFirst().retStr());
		ofileImp.printf("%s_handlers.free_obj = %sFree;\n", oclasses[i].lowerFirst().retStr(), oclasses[i].lowerFirst().retStr());
		ofileImp.printf("%s_handlers.offset   = offsetof(WrapObj, zobj);\n\n", oclasses[i].lowerFirst().retStr());
	}

	ofileImp.writeLine("return SUCCESS;\n");
	ofileImp.indentLess();
	ofileImp.writeLine("}\n\n");

	ofileImp.writeLine(str.printf("zend_module_entry %s_module_entry = {\n", ofileName.retStr()));
	ofileImp.indentMore();
	ofileImp.writeLine(str.printf("STANDARD_MODULE_HEADER,\n"));
	ofileImp.writeLine(str.printf("\"%s\",\n", ofileName.retStr()));
	ofileImp.writeLine(str.printf("NULL,\n"));
	ofileImp.writeLine(str.printf("PHP_MINIT(%s),\n", ofileName.retStr()));
	ofileImp.writeLine(str.printf("NULL,\n"));
	ofileImp.writeLine(str.printf("NULL,\n"));
	ofileImp.writeLine(str.printf("NULL,\n"));
	ofileImp.writeLine(str.printf("NULL,\n"));
	ofileImp.writeLine(str.printf("\"0.0\",\n"));
	ofileImp.writeLine(str.printf("STANDARD_MODULE_PROPERTIES\n"));
	ofileImp.indentLess();
	ofileImp.writeLine(str.printf("};\n"));

	ofileImp.writeLine(str.printf("ZEND_GET_MODULE(%s)\n", ofileName.retStr()));

	return err;
}

GenBoapPhp::GenBoapPhp(){
}

GenBoapPhp::~GenBoapPhp(){
}

BError GenBoapPhp::produce(Node* n, BString fileName){
	BError	err;
	
//	dprintf("GenBoapPhp::produce: %p\n", n);

	ofileName = fileName;
	ofileImp.open(ofileName + ".cpp", "w");
	
	// File Headers
	produceHeaderImp();
	
	// Generate code
	produceImp(n);

	// Generate trailers
	produceTrailerImp();
	ofileImp.close();

	return err;
}
