/*
 * Get info about a cycle, print out periods.
 *
 * Adapted from Terry's examples by Jeroen Belleman - September 2008
 * Modified for multi-ring system - JMB, April 2014
 *
 */
#include <iostream>
#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <TmsD.h>
#include <TmsC.h>

using namespace Tms;
using namespace std;

char *userarg=NULL;             /* Points to userline argument */

// Function to reads some data
BError tmsTest(TmsProcess & tmsProcess)
{
    BError err;
    DataInfo dataInfo;
    Data data;
    CycleInformation ci;
    UInt32 cn = 0, ocn=0;
    BString ct;
    unsigned int i, count;
    UInt32 period, start,end,h,b,mask,n;

    err = tmsProcess.getCycleInfo(cn, ct);
    if (err) {
        cerr << ct << " " << err.getString() << "\n";
    }

    for (;;usleep(500000)) {
        err = tmsProcess.getCycleInfo(cn, ct);
//      fprintf(stderr,"ocn=%1d, cn=%1d\n",ocn,cn);
        if (err) {
            cerr << "Cycleinfo:" << ct << cn << err.getString() << "\n";
        } else if (cn != ocn) {
            err = tmsProcess.getCycleInformation(ocn, ci);
            if (err) {
                cerr << "CycleInformation:" << ocn << err.getString() << "\n";
            } else {
                fprintf(stderr, "%6d: %9s\n", ocn, ci.cycleType.retStr());
                fprintf(stderr,"period start end  h bunches mask      n\n");
                count = ci.periods.number();
                for (i=0; i<count; i++) {
                    period = ci.periods[i].cyclePeriod;
                    start = ci.periods[i].startTime;
                    end = ci.periods[i].endTime;
                    h = ci.periods[i].harmonic;
                    b  = ci.periods[i].numBunches;
                    mask = ci.periods[i].bunchMask;
                    n = ci.periods[i].numValues;
                    fprintf(stderr, "  %2d  %4d  %4d %2d  %2d    0x%05x %8d\n",
                            period, start, end, h, b, mask, n);
                }
            }
        }
        ocn = cn;
    }
    return err;
}

void usage(char *s)
{
    fprintf(stderr,"Usage: %s [options] [hostname]\n",s);
    fprintf(stderr,"Options:\n");
    fprintf(stderr,"-r ring - Select ring 1 to 4. (Default: 1)\n");
    fprintf(stderr,"-u user - Save data for user (Ex: EASTB, default: nothing)\n");
    fprintf(stderr,"-h      - Print this usage message\n");

    exit(0);
}

int main(int argc, char **argv)
{
    int i;
    BError err;
    BString host = "localhost";
    TmsProcess tmsProcess;
    int ring=1;

/* Argument scanner */
    for (i=1; i<argc; i++) {
        if (argv[i][0] == '-') {    /* Option */
            switch (argv[i][1]) {
            case 'r':               /* Select ring */
                if (++i >= argc)
                    usage(argv[0]);
                ring = atoi(argv[i]);
                break;
            case 'u':               /* User line to save */
                if (++i >= argc)
                    usage(argv[0]);
                userarg = argv[i];
                break;
            default:
                usage(argv[0]);
            }
        } else {                    /* Not an option */
            host = argv[i];
        }
    }
/* End of argument scanner */
    fprintf(stderr,"User %s\n",userarg);

    // Connect to the Process service
    if (err =
        tmsProcess.connectService(BString("//") + host + "/tmsProcess" + ring)) {
        cerr << "Error: " << err.getString() << "\n";
        cerr << "Did you select the right host?\n";
        return 1;
    }
    // Run a normal data gathering cycle as a normal client would.
    if (err = tmsTest(tmsProcess)) {
        cerr << "Error: " << err.getString() << "\n";
        return 1;
    }

    return 0;
}
