#ifndef _ADATA_AVR2_H
#define _ADATA_AVR2_H

/*
** <avr2.h> - AVR2 API header file (AVR2 interface)
**
** (C) Copyright 2016 Alpha Data
**
** The integer datatypes used below that are prefixed by "_AVR2_", such
** as "_AVR2_UINT64" are defined in order to increase the portability of
** this header file but should NOT be used by application code that makes
** use of the AVR2 API.
**
** Applications should use OS-specific types such as UINT32 (Windows) or
** uint32_t (Linux C99).
*/

#if defined(_WIN32) || defined(_MSC_VER)

/* Windows */

# include <windows.h>
# include <tchar.h>

# if defined(AVR2_DLL)
    /* Compiling API library into a DLL */
#   define AVR2_EXPORT __declspec(dllexport)
# else
    /* Importing API library from DLL */
#   define AVR2_EXPORT __declspec(dllimport)
# endif
# define AVR2_CALLING_CONVENTION __cdecl

#elif defined(__linux)

/* Linux */

# include <stdint.h>
# include <wchar.h>

# define AVR2_EXPORT
# define AVR2_CALLING_CONVENTION

#elif defined(__VXWORKS__) || defined(__vxworks)

# include <vxWorks.h>
# include <semLib.h>

# define AVR2_EXPORT
# define AVR2_CALLING_CONVENTION

#else

# error Cannot detect target operating system.

#endif

#include <avr2/platform.h>
#include <avr2/status.h>
#include <avr2/struct.h>

/* Revision of the AVR2 API */
#define AVR2_H_MAKE_VERSION(super, major, minor) ((super) * 65536 + (major) * 256 + (minor))
#define AVR2_H_VERSION_SUPER (1)
#define AVR2_H_VERSION_MAJOR (0)
#define AVR2_H_VERSION_MINOR (1)
#define AVR2_H_VERSION AVR2_H_MAKE_VERSION(AVR2_H_VERSION_SUPER, AVR2_H_VERSION_MAJOR, AVR2_H_VERSION_MINOR)

/*
** Function prototypes
*/
#ifdef __cplusplus
extern "C" {
#endif

AVR2_EXPORT AVR2_STATUS
AVR2_CALLING_CONVENTION
AVR2_Close(
  AVR2_HANDLE             hDevice);

AVR2_EXPORT AVR2_STATUS
AVR2_CALLING_CONVENTION
AVR2_Command(
  AVR2_HANDLE             hDevice,
  _AVR2_UINT32            flags,
  _AVR2_UINT32            timeoutUs,
  _AVR2_UINT32            commandLength,
  const _AVR2_UINT8*      pCommand,
  _AVR2_UINT32            responseLength,
  _AVR2_UINT8*            pResponse,
  _AVR2_UINT32*           pActualResponseLength);

#if defined(_UNICODE)
# define AVR2_GetStatusString AVR2_GetStatusStringW
#else
# define AVR2_GetStatusString AVR2_GetStatusStringA
#endif

AVR2_EXPORT const char*
AVR2_CALLING_CONVENTION
AVR2_GetStatusStringA(
  AVR2_STATUS             code,
  _AVR2_BOOL              bShort);

#if defined(_WIN32) || defined(_MSC_VER)
AVR2_EXPORT const wchar_t*
AVR2_CALLING_CONVENTION
AVR2_GetStatusStringW(
  AVR2_STATUS             code,
  _AVR2_BOOL              bShort);
#endif

#if defined(_UNICODE)
# define AVR2_OpenPort AVR2_OpenPortW
#else
# define AVR2_OpenPort AVR2_OpenPortA
#endif

AVR2_EXPORT AVR2_STATUS
AVR2_CALLING_CONVENTION
AVR2_OpenPortA(
  const char*             pPortName,
  AVR2_HANDLE*            phDevice);

#if defined(_WIN32) || defined(_MSC_VER)
AVR2_EXPORT AVR2_STATUS
AVR2_CALLING_CONVENTION
AVR2_OpenPortW(
  const wchar_t*          pPortName,
  AVR2_HANDLE*            phDevice);
#endif

#ifdef __cplusplus
}
#endif

#endif
