#ifndef _ADATA_ADMXRC3_H
#define _ADATA_ADMXRC3_H

/*
** <admxrc3.h> - ADMXRC3 API header file (ADMXRC3 interface)
**
** (C) Copyright 2009-2014 Alpha Data
**
** The integer datatypes used below that are prefixed by "_ADMXRC3_", such
** as "_ADMXRC3_UINT64" are defined in order to increase the portability of
** this header file but should NOT be used by application code that makes
** use of the ADMXRC3 API.
**
** Applications should use OS-specific types such as UINT32 (Windows) or
** uint32_t (Linux C99).
*/

#if defined(_WIN32) || defined(_MSC_VER)

/* Windows */

# include <windows.h>
# include <tchar.h>

# if defined(ADMXRC3_DLL)
    /* Compiling API library into a DLL */
#   define ADMXRC3_EXPORT __declspec(dllexport)
# else
    /* Importing API library from DLL */
#   define ADMXRC3_EXPORT __declspec(dllimport)
# endif
# define ADMXRC3_CALLING_CONVENTION __cdecl

#elif defined(__linux)

/* Linux */

# include <stdint.h>
# include <wchar.h>

# define ADMXRC3_EXPORT
# define ADMXRC3_CALLING_CONVENTION

#elif defined(__VXWORKS__) || defined(__vxworks)

# include <vxWorks.h>
# include <semLib.h>

# define ADMXRC3_EXPORT
# define ADMXRC3_CALLING_CONVENTION

#else

# error Cannot detect target operating system.

#endif

#include <admxrc3/platform.h>
#include <admxrc3/status.h>
#include <admxrc3/types.h>
#include <admxrc3/structs.h>
#include <admxrc3/ticket.h>

/* Revision of the ADMXRC3 API to which these header files apply
** (see ADMXRC API specification ad-ug-0003_vX_Y.pdf) */
#define ADMXRC3_H_MAKE_VERSION(super, major, minor) ((super) * 65536 + (major) * 256 + (minor))
#define ADMXRC3_H_VERSION_SUPER (1)
#define ADMXRC3_H_VERSION_MAJOR (8)
#define ADMXRC3_H_VERSION_MINOR (2)
#define ADMXRC3_H_VERSION ADMXRC3_H_MAKE_VERSION(ADMXRC3_H_VERSION_SUPER, ADMXRC3_H_VERSION_MAJOR, ADMXRC3_H_VERSION_MINOR)

/*
** Function prototypes
*/
#ifdef __cplusplus
extern "C" {
#endif

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_Cancel(
  ADMXRC3_HANDLE             hCard);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ClearDeviceErrors(
  ADMXRC3_HANDLE             hCard);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_Close(
  ADMXRC3_HANDLE             hCard);

# if defined(_UNICODE)
#   define ADMXRC3_ConfigureFromFile ADMXRC3_ConfigureFromFileW
# else
#   define ADMXRC3_ConfigureFromFile ADMXRC3_ConfigureFromFileA
# endif

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ConfigureFromFileA(
  ADMXRC3_HANDLE             hCard,
  unsigned int               targetIndex,
  _ADMXRC3_UINT32            flags,
  const char*                pFilename);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ConfigureFromFileW(
  ADMXRC3_HANDLE             hCard,
  unsigned int               targetIndex,
  _ADMXRC3_UINT32            flags,
  const wchar_t*             pFilename);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ConfigureFromBuffer(
  ADMXRC3_HANDLE             hCard,
  unsigned int               targetIndex,
  _ADMXRC3_UINT32            flags,
  const void*                pBuffer,
  size_t                     length);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_EraseFlash(
  ADMXRC3_HANDLE             hCard,
  unsigned int               flashIndex,
  _ADMXRC3_UINT32            flags,
  _ADMXRC3_UINT64            offset,
  _ADMXRC3_UINT64            length);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_FinishDMA(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  _ADMXRC3_BOOL              bWait);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_FinishNotificationWait(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  _ADMXRC3_BOOL              bWait);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetBankInfo(
  ADMXRC3_HANDLE             hCard,
  unsigned int               bankIndex,
  ADMXRC3_BANK_INFO*         pBankInfo);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetCardInfo(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_CARD_INFO*         pCardInfo);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetCardInfoEx(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_CARD_INFOEX*       pCardInfoEx);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetClockFrequency(
  ADMXRC3_HANDLE             hCard,
  unsigned int               clockIndex,
  double*                    pActualFrequency);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetDeviceStatus(
  ADMXRC3_HANDLE             hCard,
  _ADMXRC3_UINT32            flags,
  ADMXRC3_DEVICE_STATUS*     pDeviceStatus,
  _ADMXRC3_BOOL*             pbAnyError);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetFlashBlockInfo(
  ADMXRC3_HANDLE             hCard,
  unsigned int               flashIndex,
  _ADMXRC3_UINT64            address,
  ADMXRC3_FLASHBLOCK_INFO*   pFlashBlockInfo);

#if defined(_UNICODE)
# define ADMXRC3_GetFlashInfo ADMXRC3_GetFlashInfoW
#else
# define ADMXRC3_GetFlashInfo ADMXRC3_GetFlashInfoA
#endif

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetFlashInfoA(
  ADMXRC3_HANDLE             hCard,
  unsigned int               flashIndex,
  ADMXRC3_FLASH_INFOA*       pFlashInfo);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetFlashInfoW(
  ADMXRC3_HANDLE             hCard,
  unsigned int               flashIndex,
  ADMXRC3_FLASH_INFOW*       pFlashInfo);

#if defined(_UNICODE)
# define ADMXRC3_GetFpgaInfo ADMXRC3_GetFpgaInfoW
#else
# define ADMXRC3_GetFpgaInfo ADMXRC3_GetFpgaInfoA
#endif

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetFpgaInfoA(
    ADMXRC3_HANDLE hCard,
    unsigned int targetIndex,
    ADMXRC3_FPGA_INFOA* pFpgaInfo);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetFpgaInfoW(
    ADMXRC3_HANDLE hCard,
    unsigned int targetIndex,
    ADMXRC3_FPGA_INFOW* pFpgaInfo);

#if defined(_UNICODE)
# define ADMXRC3_GetModuleInfo ADMXRC3_GetModuleInfoW
#else
# define ADMXRC3_GetModuleInfo ADMXRC3_GetModuleInfoA
#endif

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetModuleInfoA(
    ADMXRC3_HANDLE hCard,
    unsigned int moduleIndex,
    ADMXRC3_MODULE_INFOA* pModuleInfo);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetModuleInfoW(
    ADMXRC3_HANDLE hCard,
    unsigned int moduleIndex,
    ADMXRC3_MODULE_INFOW* pModuleInfo);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetSensorInfoA(
  ADMXRC3_HANDLE             hCard,
  unsigned int               sensorIndex,
  ADMXRC3_SENSOR_INFOA*      pSensorInfo);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetSensorInfoW(
  ADMXRC3_HANDLE             hCard,
  unsigned int               sensorIndex,
  ADMXRC3_SENSOR_INFOW*      pSensorInfo);

# if defined(_UNICODE)
#   define ADMXRC3_GetSensorInfo ADMXRC3_GetSensorInfoW
# else
#   define ADMXRC3_GetSensorInfo ADMXRC3_GetSensorInfoA
# endif

#if defined(_UNICODE)
# define ADMXRC3_GetStatusString ADMXRC3_GetStatusStringW
#else
# define ADMXRC3_GetStatusString ADMXRC3_GetStatusStringA
#endif

ADMXRC3_EXPORT const char*
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetStatusStringA(
  ADMXRC3_STATUS             code,
  _ADMXRC3_BOOL              bShort);

ADMXRC3_EXPORT const wchar_t*
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetStatusStringW(
  ADMXRC3_STATUS             code,
  _ADMXRC3_BOOL              bShort);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetVersionInfo(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_VERSION_INFO*      pVersionInfo);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_GetWindowInfo(
  ADMXRC3_HANDLE             hCard,
  unsigned int               windowIndex,
  ADMXRC3_WINDOW_INFO*       pWindowInfo);

#if defined(_WIN32) || defined(_MSC_VER)
__inline static void
ADMXRC3_InitializeTicket(
  ADMXRC3_TICKET* pTicket)
{
  /* Windows - OVERLAPPED struct must be initialized to 0 */
  ZeroMemory(&pTicket->Overlapped, sizeof(pTicket->Overlapped));
}
#else
  /* Linux / VxWorks - nothing to do */
# define ADMXRC3_InitializeTicket(pTicket)
#endif

#if defined(_UNICODE)
# define ADMXRC3_LoadBitstream ADMXRC3_LoadBitstreamW
#else
# define ADMXRC3_LoadBitstream ADMXRC3_LoadBitstreamA
#endif

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_LoadBitstreamA(
  const char*                pFilename,
  ADMXRC3_BITSTREAMA**       ppBitstream);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_LoadBitstreamW(
  const wchar_t*             pFilename,
  ADMXRC3_BITSTREAMW**       ppBitstream);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_Lock(
  ADMXRC3_HANDLE             hCard,
  const void*                pBuffer,
  size_t                     length,
  ADMXRC3_BUFFER_HANDLE*     phBuffer);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_MapWindow(
  ADMXRC3_HANDLE             hCard,
  unsigned int               windowIndex,
  _ADMXRC3_UINT64            offset,
  _ADMXRC3_UINT64            length,
  void**                     ppVirtualBase);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_Open(
  unsigned int               index,
  ADMXRC3_HANDLE*            phCard);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_OpenEx(
  unsigned int               index,
  _ADMXRC3_BOOL              bPassive,
  _ADMXRC3_UINT32            cooperativeLevel,
  ADMXRC3_HANDLE*            phCard);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_Read(
  ADMXRC3_HANDLE             hCard,
  unsigned int               windowIndex,
  _ADMXRC3_UINT32            flags,
  size_t                     offset,
  size_t                     length,
  void*                      pBuffer);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ReadDMA(
  ADMXRC3_HANDLE             hCard,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  void*                      pBuffer,
  size_t                     length,
  _ADMXRC3_UINT32            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ReadDMAEx(
  ADMXRC3_HANDLE             hCard,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  void*                      pBuffer,
  size_t                     length,
  _ADMXRC3_UINT64            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ReadDMALocked(
  ADMXRC3_HANDLE             hCard,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  ADMXRC3_BUFFER_HANDLE      hBuffer,
  size_t                     offset,
  size_t                     length,
  _ADMXRC3_UINT32            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ReadDMALockedEx(
  ADMXRC3_HANDLE             hCard,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  ADMXRC3_BUFFER_HANDLE      hBuffer,
  size_t                     offset,
  size_t                     length,
  _ADMXRC3_UINT64            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ReadFlash(
  ADMXRC3_HANDLE             hCard,
  unsigned int               flashIndex,
  _ADMXRC3_UINT32            flags,
  _ADMXRC3_UINT64            offset,
  size_t                     length,
  void*                      pBuffer);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ReadSensor(
  ADMXRC3_HANDLE             hCard,
  unsigned int               sensorIndex,
  ADMXRC3_SENSOR_VALUE*      pSensorValue);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_ReadVPD(
  ADMXRC3_HANDLE             hCard,
  _ADMXRC3_UINT32            flags,
  size_t                     offset,
  size_t                     length,
  void*                      pBuffer);

#if defined(_WIN32) || defined(_MSC_VER)
ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_RegisterWin32Event(
  ADMXRC3_HANDLE             hCard,
  _ADMXRC3_UINT32            notification,
  HANDLE                     hEvent);
#endif

#if defined(__VXWORKS__) || defined(__vxworks)
ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_RegisterVxwSem(
  ADMXRC3_HANDLE             hCard,
  _ADMXRC3_UINT32            notification,
  SEM_ID                     semId);
#endif

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_SetClockFrequency(
  ADMXRC3_HANDLE             hCard,
  unsigned int               clockIndex,
  _ADMXRC3_UINT32            flags,
  double                     frequency,
  double*                    pActualFrequency);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_StartReadDMA(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  void*                      pBuffer,
  size_t                     length,
  _ADMXRC3_UINT32            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_StartReadDMAEx(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  void*                      pBuffer,
  size_t                     length,
  _ADMXRC3_UINT64            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_StartReadDMALocked(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  ADMXRC3_BUFFER_HANDLE      hBuffer,
  size_t                     offset,
  size_t                     length,
  _ADMXRC3_UINT32            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_StartReadDMALockedEx(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  ADMXRC3_BUFFER_HANDLE      hBuffer,
  size_t                     offset,
  size_t                     length,
  _ADMXRC3_UINT64            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_StartNotificationWait(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  _ADMXRC3_UINT32            notification);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_StartWriteDMA(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  const void*                pBuffer,
  size_t                     length,
  _ADMXRC3_UINT32            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_StartWriteDMAEx(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  const void*                pBuffer,
  size_t                     length,
  _ADMXRC3_UINT64            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_StartWriteDMALocked(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  ADMXRC3_BUFFER_HANDLE      hBuffer,
  size_t                     offset,
  size_t                     length,
  _ADMXRC3_UINT32            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_StartWriteDMALockedEx(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_TICKET*            pTicket,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  ADMXRC3_BUFFER_HANDLE      hBuffer,
  size_t                     offset,
  size_t                     length,
  _ADMXRC3_UINT64            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_SyncFlash(
  ADMXRC3_HANDLE             hCard,
  unsigned int               flashIndex,
  _ADMXRC3_UINT32            flags);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_Unconfigure(
  ADMXRC3_HANDLE             hCard,
  unsigned int               targetIndex,
  _ADMXRC3_UINT32            flags);

#if defined(_UNICODE)
# define ADMXRC3_UnloadBitstream ADMXRC3_UnloadBitstreamW
#else
# define ADMXRC3_UnloadBitstream ADMXRC3_UnloadBitstreamA
#endif

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_UnloadBitstreamA(
  ADMXRC3_BITSTREAMA*        pBitstream);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_UnloadBitstreamW(
  ADMXRC3_BITSTREAMW*        pBitstream);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_Unlock(
  ADMXRC3_HANDLE             hCard,
  ADMXRC3_BUFFER_HANDLE      hBuffer);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_UnmapWindow(
  ADMXRC3_HANDLE             hCard,
  void*                      pVirtualBase);

#if defined(_WIN32) || defined(_MSC_VER)
ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_UnregisterWin32Event(
  ADMXRC3_HANDLE             hCard,
  _ADMXRC3_UINT32            notification,
  HANDLE                     hEvent);
#endif

#if defined(__VXWORKS__) || defined(__vxworks)
ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_UnregisterVxwSem(
  ADMXRC3_HANDLE             hCard,
  _ADMXRC3_UINT32            notification,
  SEM_ID                     semId);
#endif

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_Write(
  ADMXRC3_HANDLE             hCard,
  unsigned int               windowIndex,
  _ADMXRC3_UINT32            flags,
  size_t                     offset,
  size_t                     length,
  const void*                pBuffer);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_WriteDMA(
  ADMXRC3_HANDLE             hCard,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  const void*                pBuffer,
  size_t                     length,
  _ADMXRC3_UINT32            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_WriteDMAEx(
  ADMXRC3_HANDLE             hCard,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  const void*                pBuffer,
  size_t                     length,
  _ADMXRC3_UINT64            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_WriteDMALocked(
  ADMXRC3_HANDLE             hCard,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  ADMXRC3_BUFFER_HANDLE      hBuffer,
  size_t                     offset,
  size_t                     length,
  _ADMXRC3_UINT32            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_WriteDMALockedEx(
  ADMXRC3_HANDLE             hCard,
  unsigned int               dmaChannel,
  _ADMXRC3_UINT32            flags,
  ADMXRC3_BUFFER_HANDLE      hBuffer,
  size_t                     offset,
  size_t                     length,
  _ADMXRC3_UINT64            localAddress);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_WriteFlash(
  ADMXRC3_HANDLE             hCard,
  unsigned int               flashIndex,
  _ADMXRC3_UINT32            flags,
  _ADMXRC3_UINT64            offset,
  size_t                     length,
  const void*                pBuffer);

ADMXRC3_EXPORT ADMXRC3_STATUS
ADMXRC3_CALLING_CONVENTION
ADMXRC3_WriteVPD(
  ADMXRC3_HANDLE             hCard,
  _ADMXRC3_UINT32            flags,
  size_t                     offset,
  size_t                     length,
  const void*                pData);

#if defined(_WIN32) || defined(_MSC_VER)
ADMXRC3_EXPORT void
ADMXRC3_CALLING_CONVENTION
ADMXRC3_SetWin32ExceptionLevel(
  unsigned int level);
#endif

#ifdef __cplusplus
}
#endif

#endif
