/*
** struct.h - structures used in ADMXRC2 API calls
**
** (C) Copyright 2000-2014 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_STRUCT_H
#define _ADATA_ADMXRC2_STRUCT_H

/*
** Card information structure
*/
typedef struct _ADMXRC2_CARD_INFO {
  ADMXRC2_CARDID     CardID;          /* ID of card                            */
  _ADMXRC2_DWORD     SerialNum;       /* serial number of card                 */
  ADMXRC2_BOARD_TYPE BoardType;       /* type of card                          */
  ADMXRC2_FPGA_TYPE  FPGAType;        /* type of FPGA fitted                   */
  unsigned long      NumClock;        /* number of programmable clocks         */
  unsigned long      NumDMAChan;      /* number of DMA channels                */
  unsigned long      NumRAMBank;      /* number of RAM banks (fitted or not)   */
  unsigned long      NumSpace;        /* number of spaces                      */
  _ADMXRC2_DWORD     RAMBanksFitted;  /* bitmap of banks fitted (max 32 banks) */
  _ADMXRC2_BYTE      BoardRevision;   /* board rev, 0xab, a = major, b = minor */
  _ADMXRC2_BYTE      LogicRevision;   /* logic rev, 0xab, a = major, b = minor */
} ADMXRC2_CARD_INFO;

/*
** Extended card information structure
*/
typedef struct _ADMXRC2_CARD_INFOEX {
  ADMXRC2_CARDID     CardID;          /* ID of card                            */
  _ADMXRC2_DWORD     SerialNum;       /* serial number of card                 */
  ADMXRC2_BOARD_TYPE BoardType;       /* type of card                          */
  ADMXRC2_FPGA_TYPE  FPGAType;        /* type of FPGA fitted                   */
  unsigned int       NumClock;        /* number of programmable clocks         */
  unsigned int       NumDMAChan;      /* number of DMA channels                */
  unsigned int       NumRAMBank;      /* number of RAM banks (fitted or not)   */
  unsigned int       NumSpace;        /* number of spaces                      */
  unsigned int       NumSensor;       /* number of sensors                     */
  unsigned int       NumTargetFPGA;   /* number of target FPGAs                */
  _ADMXRC2_DWORD     RAMBanksFitted;  /* bitmap of banks fitted (max 32 banks) */
  _ADMXRC2_BYTE      BoardRevision;   /* board rev, 0xab, a = major, b = minor */
  _ADMXRC2_BYTE      LogicRevision;   /* logic rev, 0xab, a = major, b = minor */
} ADMXRC2_CARD_INFOEX;

/*
** RAM bank information structure
*/
typedef struct _ADMXRC2_BANK_INFO {
  unsigned long    Type;    /* bitmask of RAM mode(s) supported      */
  unsigned long    Width;   /* in bits, valid whether fitted or not  */
  unsigned long    Size;    /* in words, valid whether fitted or not */
  _ADMXRC2_BOOLEAN Fitted;  /* TRUE if present (fitted to card)      */
} ADMXRC2_BANK_INFO;

typedef struct _ADMXRC2_FPGA_INFO {
  ADMXRC2_FPGA_TYPE Type;             /* Device; see ADMXRC2_FPGA_TYPE                     */
  char              Package[32];      /* Package as a string, e.g. "FF1738"                */
  int               Speed;            /* Speed grade, or -1 if not known                   */
  int               Stepping;         /* Stepping level, or -1 if not known                */
  int               Industrial;       /* 1 => industrial, 0 => commerical, -1 => not known */
  int               SCD;              /* SCD, or -1 if not known                           */
} ADMXRC2_FPGA_INFO;

/*
** Structure returning version information
** Superseded by ADMXRC2_VERSION_INFOEX
*/
typedef struct _ADMXRC2_VERSION_INFO {
  _ADMXRC2_BYTE DriverMinor;
  _ADMXRC2_BYTE DriverMajor;
  _ADMXRC2_BYTE APIMinor;
  _ADMXRC2_BYTE APIMajor;
} ADMXRC2_VERSION_INFO;

/*
** Structure returning version information
*/
typedef struct _ADMXRC2_VERSION_INFOEX {
  _ADMXRC2_UINT32 DriverMajor;
  _ADMXRC2_UINT32 DriverMinor;
  _ADMXRC2_UINT32 DriverBugfix;
  _ADMXRC2_UINT32 DriverBuild;
  _ADMXRC2_UINT32 APIMajor;
  _ADMXRC2_UINT32 APIMinor;
  _ADMXRC2_UINT32 APIBugfix;
  _ADMXRC2_UINT32 APIBuild;
} ADMXRC2_VERSION_INFOEX;

/*
** A structure used to map a user buffer for Direct Master
** access by the FPGA.
*/
typedef struct _ADMXRC2_BUFFERMAP {
  unsigned long   MaxPages;      /* User initialises to length of PCI address buffer      */
  _ADMXRC2_DWORD* PagesPci;      /* User initialises to point to PCI address buffer       */
  unsigned long   PageLength;    /* Receives size in bytes of a page                      */
  unsigned long   PageBits;      /* Number of bits representing a page offset             */
  unsigned long   PagesSpanned;  /* Receives number of pages spanned                      */
  unsigned long   BytesSpanned;  /* Receives number of bytes spanned                      */
  unsigned long   InitOffset;    /* Receives page offset within 1st page of start of span */
} ADMXRC2_BUFFERMAP;

/*
** Description of a local bus space (a window onto local bus)
*/
typedef struct _ADMXRC2_SPACE_INFO {
  void*          VirtualBase;   /* Application space window         */
  unsigned long  VirtualSize;   /* Size of application space window */
#if defined(_WIN32) || defined(_MSC_VER)
  /* Windows */
  DWORD          PhysicalBase;  /* Host I/O bus address             */
  DWORD          LocalBase;     /* Local bus address                */
#else
  /* Linux / VxWorks */
  unsigned long  PhysicalBase;  /* Host I/O bus address             */
  unsigned long  LocalBase;     /* Local bus address                */
#endif
  unsigned long  LocalSize;     /* Size in bytes of local bus space */
} ADMXRC2_SPACE_INFO;

typedef struct _ADMXRC2_SPACE_INFOEX {
  _ADMXRC2_UINT64 VirtualSize;   /* Size of window in a process' address space       */
  _ADMXRC2_UINT64 BusBase;       /* Host I/O bus address                             */
  _ADMXRC2_UINT64 BusSize;       /* Host I/O bus size                                */
  _ADMXRC2_UINT64 LocalBase;     /* Local bus address                                */
  _ADMXRC2_UINT64 LocalSize;     /* Size in bytes of local bus space                 */
  _ADMXRC2_UINT32 Flags;         /* See ADMXRC2_SPACE_xxx flags in <admxrc2/types.h> */
  _ADMXRC2_UINT32 _Reserved1;
} ADMXRC2_SPACE_INFOEX;

#endif
