/*
** <admxrc2/debugtss.h> - Structures supporting ADMXRC2 Debug Timestampting extension.
**
** (C) Copyright 2016 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_DEBUGTSS_H
#define _ADATA_ADMXRC2_DEBUGTSS_H

#if defined(__linux)
# include <sys/time.h> /* For struct timeval */
#endif

#include <admxrc2/debugtst.h>

typedef struct _ADMXRC2_DEBUGTS_INFO_DMA {
  _ADMXRC2_UINT8  Facility;          /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  _ADMXRC2_UINT8  EventType;         /* ADMXRC2_DEBUGTS_EVENT_DMASETUPSTART */
  _ADMXRC2_UINT16 ChunkIndex;        /* DMA chunk index, truncated to 16 bits if necssary */
  _ADMXRC2_UINT32 Argument;          /* Event-specific information */
} ADMXRC2_DEBUGTS_INFO_DMA;

typedef struct _ADMXRC2_DEBUGTS_INFO_DMASETUPSTART {
  _ADMXRC2_UINT8  Facility;          /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  _ADMXRC2_UINT8  EventType;         /* ADMXRC2_DEBUGTS_EVENT_DMASETUPSTART */
  _ADMXRC2_UINT16 ChunkIndex;        /* DMA chunk index, truncated to 16 bits if necssary */
  _ADMXRC2_UINT32 PagesRequested;    /* Number of pages requested to be mapped */
} ADMXRC2_DEBUGTS_INFO_DMASETUPSTART;

typedef struct _ADMXRC2_DEBUGTS_INFO_DMASETUPFINISH {
  _ADMXRC2_UINT8  Facility;          /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  _ADMXRC2_UINT8  EventType;         /* ADMXRC2_DEBUGTS_EVENT_DMASETUPFINISH */
  _ADMXRC2_UINT16 ChunkIndex;        /* DMA chunk index, truncated to 16 bits if necssary */
  _ADMXRC2_UINT32 BytesMapped;       /* Number of bytes actually mapped */
} ADMXRC2_DEBUGTS_INFO_DMASETUPFINISH;

typedef struct _ADMXRC2_DEBUGTS_INFO_DMATEARDOWNSTART {
  _ADMXRC2_UINT8  Facility;          /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  _ADMXRC2_UINT8  EventType;         /* ADMXRC2_DEBUGTS_EVENT_DMATEARDOWNSTART */
  _ADMXRC2_UINT16 ChunkIndex;        /* DMA chunk index, truncated to 16 bits if necssary */
  _ADMXRC2_UINT16 _Reserved1[2];
} ADMXRC2_DEBUGTS_INFO_DMATEARDOWNSTART;

typedef struct _ADMXRC2_DEBUGTS_INFO_DMATEARDOWNFINISH {
  _ADMXRC2_UINT8  Facility;          /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  _ADMXRC2_UINT8  EventType;         /* ADMXRC2_DEBUGTS_EVENT_DMATEARDOWNFINISH */
  _ADMXRC2_UINT16 ChunkIndex;        /* DMA chunk index, truncated to 16 bits if necssary */
  _ADMXRC2_UINT16 _Reserved1[2];
} ADMXRC2_DEBUGTS_INFO_DMATEARDOWNFINISH;

typedef struct _ADMXRC2_DEBUGTS_INFO_DMAHWSTART {
  _ADMXRC2_UINT8  Facility;          /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  _ADMXRC2_UINT8  EventType;         /* ADMXRC2_DEBUGTS_EVENT_DMAHWSTART */
  _ADMXRC2_UINT16 ChunkIndex;        /* DMA chunk index, truncated to 16 bits if necssary */
  _ADMXRC2_UINT16 _Reserved1[2];
} ADMXRC2_DEBUGTS_INFO_DMAHWSTART;

typedef struct _ADMXRC2_DEBUGTS_INFO_DMAHWFINISH {
  _ADMXRC2_UINT8  Facility;          /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  _ADMXRC2_UINT8  EventType;         /* ADMXRC2_DEBUGTS_EVENT_DMAHWFINISH */
  _ADMXRC2_UINT16 ChunkIndex;        /* DMA chunk index, truncated to 16 bits if necssary */
  _ADMXRC2_UINT16 _Reserved1[2];
} ADMXRC2_DEBUGTS_INFO_DMAHWFINISH;

typedef struct _ADMXRC2_DEBUGTS_ENTRY {
  union {
    struct {
      _ADMXRC2_UINT8                       Facility;          /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
      _ADMXRC2_UINT8                       EventType;         /* Event type, specific to facility */
      _ADMXRC2_UINT8                       EventSpecific[6];  /* Event-specific information */
    }                                      AsFields;
    ADMXRC2_DEBUGTS_INFO_DMA               AsDMA;
    ADMXRC2_DEBUGTS_INFO_DMASETUPSTART     AsDMASetupStart;
    ADMXRC2_DEBUGTS_INFO_DMASETUPFINISH    AsDMASetupFinish;
    ADMXRC2_DEBUGTS_INFO_DMATEARDOWNSTART  AsDMATeardownStart;
    ADMXRC2_DEBUGTS_INFO_DMATEARDOWNFINISH AsDMATeardownFinish;
    ADMXRC2_DEBUGTS_INFO_DMAHWSTART        AsDMAHWStart;
    ADMXRC2_DEBUGTS_INFO_DMAHWFINISH       AsDMAHWFinish;
    _ADMXRC2_UINT64                        AsUINT64;          /* Above as 64-bit value */
  }                                        Information;       /* Information that indicates to what event the timestamp pertains */
  _ADMXRC2_UINT64                          Timestamp;         /* Timestamp value, in counter increments */
} ADMXRC2_DEBUGTS_ENTRY;

typedef struct _ADMXRC2_DEBUGTS_STATUS {
  size_t            Count;      /* Number of entries currently occupied in timestamp buffer */
  _ADMXRC2_UINT32   Status;     /* See ADMXRC2_DEBUGTS_STATUS_* flags */
} ADMXRC2_DEBUGTS_STATUS;

typedef struct _ADMXRC2_DEBUGTS_INFO {
  _ADMXRC2_UINT64   Frequency;     /* Frequency that timestamp counter increments, in Hz */
  _ADMXRC2_UINT64   InitTimestamp; /* Timestamp at InitTime */
#if defined(_WIN32)
  FILETIME          InitTime;      /* Initial system time */
#elif defined(__linux)
  struct timeval    InitTime;      /* Initial system time */
#else
# error Cannot detect target operating system.
#endif
  size_t            BufferSize;    /* Size of timestamp buffer for this facility, in 16-byte entries. */
} ADMXRC2_DEBUGTS_INFO;

#endif
