/*
** File: space.h
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for "Space" IOCTL handlers.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_ADMXRC2_SPACE_H)
#define ADATA_ADMXRC2_SPACE_H

#include <df.h>
#include "device.h"
#include <admxrc2/types.h>

extern DfIoStatus
ioctlGetSpaceInfo(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlGetSpaceConfig(
	Admxrc2DeviceContext* pDevCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlSetSpaceConfig(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

#endif
