/*
** File: lock.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for I/O IOCTL handlers relating to locking
**          down user-space buffers.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_ADMXRC2_LOCK_H)
#define ADATA_ADMXRC2_LOCK_H

#include <df.h>
#include "device.h"

extern BufferDescription*
referenceBufferHandle(
  Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  uint32_t handle);

extern boolean_t
dereferenceBufferDescription(
  Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  BufferDescription* pDescription);

extern void
cleanupLockedBuffers(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx);

extern DfIoStatus
ioctlLock(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlLockThunk(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);
#endif

extern DfIoStatus
ioctlUnlock(
	Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

# if ADMXRC2_LOCKED_BUFFERS_GLOBAL
extern void
initLockedBuffers(
	DfDriverObject* pDrvObj);
# endif

#endif
