/*
** File: fpga.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for FPGA configuration IOCTL handlers.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_ADMXRC2_FPGA_H)
#define ADATA_ADMXRC2_FPGA_H

#include <df.h>
#include "device.h"

extern DfIoStatus
ioctlConfigure(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlConfigureThunk(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);
#endif

extern DfIoStatus
ioctlConfigureDma(
  Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  DfClientRequest* pRequest,
  void* pBuffer,
  unsigned int inSize);

#if DF_NEED_THUNK
extern DfIoStatus
ioctlConfigureDmaThunk(
  Admxrc2DeviceContext* pDevCtx,
  Admxrc2ClientContext* pClCtx,
  DfClientRequest* pRequest,
  void* pBuffer,
  unsigned int inSize);
#endif

extern DfIoStatus
ioctlUnconfigure(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

#endif
