/*
** File: dflist.h  
** Project: Driver Framework
** Purpose: Platform-independent list functions
**
** (C) Copyright Alpha Data 2010
*/

#if !defined(ADATA_DF_DFLIST_H)
#define ADATA_DF_DFLIST_H

struct _DfListNode;
typedef struct _DfListNode DfListNode;

struct _DfListNode {
  DfListNode* pNext;
  DfListNode* pPrev;
};

typedef DfListNode DfList;

DF_DECLARE_INLINE_FUNC(void, dfListInit)(
  DfList* pList)
{
  pList->pPrev = pList->pNext = pList;
}

DF_DECLARE_INLINE_FUNC(void, dfListAddToTail)(
  DfList* pList,
  DfListNode* pNode)
{
  DfListNode* pTail;

  pTail = pList->pPrev;
  pList->pPrev = pNode;
  pTail->pNext = pNode;
  pNode->pNext = pList;
  pNode->pPrev = pTail;
}

DF_DECLARE_INLINE_FUNC(void, dfListRemove)(
  DfListNode* pNode)
{
  DfListNode* pNext;
  DfListNode* pPrev;

  pNext = pNode->pNext;
  pPrev = pNode->pPrev;
  pNext->pPrev = pPrev;
  pPrev->pNext = pNext;
}

DF_DECLARE_INLINE_FUNC(boolean_t, dfListIsEmpty)(
  DfList* pList)
{
  return (pList->pNext == pList) ? TRUE : FALSE;
}

DF_DECLARE_INLINE_FUNC(DfListNode*, dfListGetHead)(
  DfList* pList)
{
  DfListNode* pHead = pList->pNext;

  if (pHead == pList) {
    return NULL;
  } else {
    return pHead;
  }
}

DF_DECLARE_INLINE_FUNC(DfListNode*, dfListGetTail)(
  DfList* pList)
{
  DfListNode* pTail = pList->pPrev;

  if (pTail == pList) {
    return NULL;
  } else {
    return pTail;
  }
}

DF_DECLARE_INLINE_FUNC(void, dfListConfiscate)(
  DfList* pDst,
  DfList* pSrc)
{
  DfListNode* pHead = pSrc->pNext;
  DfListNode* pTail = pSrc->pPrev;

  if (pHead == pSrc) {
    dfListInit(pDst);
  } else {
    pDst->pNext = pHead;
    pDst->pPrev = pTail;
    pHead->pPrev = pDst;
    pTail->pNext = pDst;
    dfListInit(pSrc);
  }
}

DF_DECLARE_INLINE_FUNC(DfListNode*, dfListGetNext)(
  DfList* pList,
  DfListNode* pNode)
{
  DfListNode* pNext = pNode->pNext;

  if (pNext == pList) {
    return NULL;
  } else {
    return pNext;
  }
}

DF_DECLARE_INLINE_FUNC(DfListNode*, dfListGetPrev)(
  DfList* pList,
  DfListNode* pNode)
{
  DfListNode* pPrev = pNode->pPrev;

  if (pPrev == pList) {
    return NULL;
  } else {
    return pPrev;
  }
}

#endif
