/*
** File: v5clksynth_common.h  
** Project: ADB3 core driver
** Purpose: Exports common functions for Virtex-5 PLL clock synthesizer
**
** (C) Copyright Alpha Data 2011
*/

#ifndef _ADATA_CORE_V5CLKSYNTH_COMMON_H
#define _ADATA_CORE_V5CLKSYNTH_COMMON_H

#include <df.h>
#include "device.h"
#include "v5clksynth.h"

extern V5ClkSynthClockWordStatus
v5ClkSynthClockWord(
  uint32_t flags,
	uint32_t refFrequency,
	uint64_t frequencyReq,
	uint64_t frequencyMin,
	uint64_t frequencyMax,
	CoreClockWord* pClockWord);

extern boolean_t
v5ClkSynthInit(
  Adb3CoreDeviceContext* pDevCtx,
  V5ClkSynthDeviceContext* pV5ClkSynthCtx,
  unsigned int lclkRef,
  uint32_t* pFOut);

extern void
v5ClkSynthUninit(
  Adb3CoreDeviceContext* pDevCtx,
  V5ClkSynthDeviceContext* pV5ClkSynthCtx);

extern V5ClkSynthProgramStatus
v5ClkSynthProgram(
  Adb3CoreDeviceContext* pDevCtx,
  V5ClkSynthDeviceContext* pV5ClkSynthCtx,
  V5ClkSynthProgramRequest* pRequest,
  const CoreClockWord* pClockWord,
  V5ClkSynthProgramCallback* pCallback);

/* Must be called in thread context */
extern V5ClkSynthProgramStatus
v5ClkSynthProgramSync(
  Adb3CoreDeviceContext* pDevCtx,
  V5ClkSynthDeviceContext* pV5ClkSynthCtx,
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
v5ClkSynthSaveState(
  Adb3CoreDeviceContext* pDevCtx,
  V5ClkSynthDeviceContext* pV5ClkSynthCtx);

/* Must be called in thread context */
extern V5ClkSynthProgramStatus
v5ClkSynthRestoreState(
  Adb3CoreDeviceContext* pDevCtx,
  V5ClkSynthDeviceContext* pV5ClkSynthCtx);

/* Convenience functions */

extern ClockProgramStatus
v5ClkSynthMapProgramStatus(
  V5ClkSynthProgramStatus status);

extern ClockWordStatus
v5ClkSynthMapClockWordStatus(
  V5ClkSynthClockWordStatus status);

#endif
