/*
** File: pci9xxx_93x6.h  
** Project: ADB3 core driver
** Purpose: Exports functions for accessing the 93x6 EEPROM on PCI9080-based and PCI9656-based cards.
**

** (C) Copyright Alpha Data 2009-2010
*/

#ifndef _ADB3_CORE_PCI9XXX_93X6_H
#define _ADB3_CORE_PCI9XXX_93X6_H

#include "device.h"
#include "pci9xxx.h"

/*
** EEPROM instructions: these consist of
**
**    { start_bit, opcode[1:0] } or
**    { start_bit, opcode[1:0], address[n-1:n-2] }
*/
#define EE_READ  (0x6)    /* { start_bit, opcode[1:0] } for READ instruction  */
#define EE_WRITE (0x5)    /* { start_bit, opcode[1:0] } for WRITE instruction */
#define EE_WREN  (0x13)   /* { start_bit, opcode[1:0], address[n-1:n-2] } for WREN instruction */
#define EE_WDS   (0x10)   /* { start_bit, opcode[1:0], address[n-1:n-2] } for WDS instruction */

/* Parameters specific to 9346 EEPROM */
static const unsigned int addressLength9346 = 6U;
static const unsigned int instructionLength9346 = 9U;
static const unsigned int eepromSize9346 = 0x80U;

/* Parameters specific to 9356 EEPROM */
static const unsigned int addressLength9356 = 8U;
static const unsigned int instructionLength9356 = 11U;
static const unsigned int eepromSize9356 = 0x100U;

/* Parameters specific to 9366 EEPROM */
static const unsigned int addressLength9366 = 8U;
static const unsigned int instructionLength9366 = 11U;
static const unsigned int eepromSize9366 = 0x200U;

extern void
read93x6(
	Pci9080Registers* pRegs,
  DfMemoryHandle hRegs,
	boolean_t bIsPci9656,
	unsigned int instrLen,
	unsigned int addrLen,
	uint8_t location,
	uint16_t* pVal16);

extern boolean_t
write93x6(
	Pci9080Registers* pRegs,
  DfMemoryHandle hRegs,
	boolean_t bIsPci9656,
	unsigned int instrLen,
	unsigned int addrLen,
	uint8_t location,
	uint16_t val16);

extern CoreVpdStatus
read93x6Buffer(
	Adb3CoreDeviceContext* pDevCtx,
	boolean_t bIsPci9656,
  unsigned int addrLen,
  unsigned int instrLen,
	uint32_t address,
	size_t length,
	void* pData);

extern CoreVpdStatus
write93x6Buffer(
	Adb3CoreDeviceContext* pDevCtx,
	boolean_t bIsPci9656,
  unsigned int addrLen,
  unsigned int instrLen,
	uint32_t address,
	size_t length,
	const void* pData);

#endif
