/*
** File: ics307.h  
** Project: ADB3 core driver
** Purpose: Exports functions for programming the ICS307 clock generator.
**
** (C) Copyright Alpha Data 2013
*/

#ifndef _ADATA_CORE_ICS307_H
#define _ADATA_CORE_ICS307_H

#include "device.h"
#include "coreif.h"

struct _Adb3CoreDeviceContext;
struct _Ics307ProgramRequest;
typedef struct _Ics307ProgramRequest Ics307ProgramRequest;
struct _Ics307ProgramRequestSync;
typedef struct _Ics307ProgramRequestSync Ics307ProgramRequestSync;

typedef enum _Ics307InterfaceType {
  Ics307InterfaceTypeXrc4, /* Programming interface on ADM-XRC-4LX / -4SX */
  Ics307InterfaceTypeXpl,  /* Programming interface on ADM-XPL / -XP / -XPI */
} Ics307InterfaceType;

typedef struct _Ics307DeviceContext {
  DfTimer timer;       /* Timer for checking that clock synthesizer programming was successful */
	uint32_t* pReg;      /* Address of control register */
  DfMemoryHandle hReg; /* Handle to control register */
  Ics307InterfaceType progIf; /* Programming interface */
  struct {
    uint32_t frequency; /* Current output frequency */
    uint8_t smapClkDiv; /* Current SelectMap clock divide: 0 => /2, 1 => /1.5, 2 => /1 */
  } curr;
  struct { /* Used to save & restore state when powering down & up */
    CoreClockWord last;
    boolean_t bLastValid;
  } save;
} Ics307DeviceContext;

typedef enum _Ics307ClockWordStatus {
  Ics307ClockWordStatusSuccess = 0,
  Ics307ClockWordStatusOutOfRange = 1,
  Ics307ClockWordStatusGeneralFailure = 2
} Ics307ClockWordStatus;

typedef enum _Ics307ProgramStatus {
  Ics307ProgramStatusSuccess = 0,
  Ics307ProgramStatusHardwareError = 1,
  Ics307ProgramStatusGeneralFailure = 2
} Ics307ProgramStatus;

typedef void Ics307ProgramCallback(struct _Adb3CoreDeviceContext* pDevCtx, Ics307DeviceContext* pIcs307Ctx, Ics307ProgramRequest* pRequest, Ics307ProgramStatus status);

struct _Ics307ProgramRequest {
  Ics307DeviceContext* pIcs307Ctx;
  Ics307ProgramCallback* pCallback;
  CoreClockWord clockWord;
};

struct _Ics307ProgramRequestSync {
  Ics307ProgramRequest request;
  DfEvent ev;
  Ics307ProgramStatus status;
};

#endif
