/*
** File: flash_legacy.h  
** Project: ADB3 core driver
** Purpose: Declares functions for dealing with legacy (non-CFI) Flash devices.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_CORE_FLASH_LEGACY_H)
#define ADATA_CORE_FLASH_LEGACY_H

#include <df.h>
#include "device.h"
#include "coreif.h"

/* Deallocate data structures used for a legacy Flash device */
extern void
flashLegacyCleanup(
  LegacyFlashInformation* pLegacyInfo);

/* Attempt to identify a legacy Flash device and determine its geometry */
extern boolean_t
flashLegacyIdentify(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int bankIndex);

/* Erase an (entire) block of a Legacy Flash device */
extern CoreFlashStatus
flashLegacyEraseBlock(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int index,
  uint64_t blockAddress);

/* Write an (entire) block of a Legacy Flash device */
extern CoreFlashStatus
flashLegacyWriteBlock(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int bankIndex,
  uint64_t blockAddress,
  uint64_t length,
  const void* pData);

#endif
