/*
** File: avr_flash.h  
** Project: ADB3 core driver
** Purpose: Exports definitions for accessing the AVR uC's Flash memory
**
** (C) Copyright Alpha Data 2011
**
** These functions will work correctly only if the AVR uC is in service mode.
** If not in service mode, the result of calling these functions will be
** AvrFlashNotServiceMode.
*/

#ifndef _ADATA_CORE_AVR_FLASH_H
#define _ADATA_CORE_AVR_FLASH_H

#include "avr_common.h"

typedef enum _AvrFlashStatus {
  AvrFlashSuccess         = 0,    /* Success */
  AvrFlashTimeout         = 1,    /* AVR uC didn't respond within allotted time */
  AvrFlashNotServiceMode  = 2,    /* AVR uC is not in service mode */
  AvrFlashInvalidRegion   = 3,    /* 'address' and/or 'length' were out of bounds for size of Flash in AVR uC */
  AvrFlashGeneralFailure  = 4,    /* Failed for reason that can't be determined */
  AvrFlashHardwareFailure = 0x100
} AvrFlashStatus;

/* Must be called in thread context */
extern AvrFlashStatus
avrFlashRead(
	Adb3CoreDeviceContext* pDevCtx,
  AvrDeviceContext* pAvrCtx,
  uint32_t address,      /* uC Flash memory space byte address */
  uint32_t length,       /* in bytes */
  uint8_t* pBuffer);     /* Buffer to hold data read */

/* Must be called in thread context */
extern AvrFlashStatus
avrFlashWrite(
	Adb3CoreDeviceContext* pDevCtx,
  AvrDeviceContext* pAvrCtx,
  uint32_t address,      /* uC Flash memory space byte address */
  uint32_t length,       /* in bytes */
  const uint8_t* pData); /* Data to be written */

/* Must be called in thread context */
extern AvrFlashStatus
avrFlashErase(
	Adb3CoreDeviceContext* pDevCtx,
  AvrDeviceContext* pAvrCtx,
  uint32_t address,      /* uC Flash memory space byte address */
  uint32_t length);      /* in bytes */

#endif
