/*
** File: adpexrc5t.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to for ADPe-XRC-5T.
**
** (C) Copyright Alpha Data 2009-2010
*/

#ifndef _ADATA_CORE_ADPEXRC5T_H
#define _ADATA_CORE_ADPEXRC5T_H

#include <df.h>
#include "adb3.h"

#define NUM_ADB3_ADPEXRC5T_DMA_CHANNEL (4)

/* Always LITTLE ENDIAN in hardware */
#pragma pack(1)
typedef struct _ModelRegsAdpexrc5t {
	uint32_t _reserved1[2];      /* 0x0000 */
	uint32_t mclkCtl;            /* 0x0008 */
	uint32_t _reserved2[1];      /* 0x000C */
	uint32_t lclkCtl;            /* 0x0010 */
	uint32_t lclkStat1;          /* 0x0014 */
	uint32_t lclkStat2;          /* 0x0018 */
	uint32_t lclkStat3;          /* 0x001C */
	uint8_t  selectMap[4];       /* 0x0020 */
	uint32_t fpgaCtl;            /* 0x0024 */
	uint32_t intCtl;             /* 0x0028 */
	uint32_t intStat;            /* 0x002C */
	uint32_t pwrCtl;             /* 0x0030 */
	uint32_t pwrStat;            /* 0x0034 */
	uint32_t sysMonCtl;          /* 0x0038 */
	uint32_t _reserved3[1];      /* 0x003C */
  uint32_t mptlStat;           /* 0x0040 */
  uint32_t gtpStat;            /* 0x0044 */
  uint16_t gpioIn;             /* 0x0048 */
  uint16_t gpioOut;            /* 0x004A */
  uint32_t mptlError;          /* 0x004C */
	uint32_t _reserved4[60];     /* 0x010C */
	uint32_t flashCtl;           /* 0x0100 */
	uint32_t flashAddr;          /* 0x0104 */
	uint32_t flashData;          /* 0x0108 */
	uint32_t _reserved5[189];    /* 0x010C */
	uint8_t	 sysMon[0x100];      /* 0x0400 */
} ModelRegsAdpexrc5t;          /* 0x0500 */
#pragma pack()

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdpexrc5tRev0 {
	uint16_t version;       /* Revision of this structure (0) */
	uint16_t length;        /* Length of this structure including checksum */
	uint32_t serial;
	uint32_t modifications;
	uint32_t lclkRef;
	uint32_t mclkRef0;
	uint32_t mclkRef1;
	struct {
		uint16_t speed;       /* in units of 100 kHz */
		uint8_t	 order;
    uint8_t  _reserved1;
    uint16_t link;        /* Byte offset in VPD of extended info */
    uint16_t _reserved2;
	} sdram[4];
	struct {
		uint16_t speedMax;    /* in units of 100 kHz */
		uint16_t speedMin;    /* in units of 100 kHz */
		uint8_t	 order;
    uint8_t  _reserved1;
    uint16_t link;        /* Byte offset in VPD of extended info */
	} ssram[2];
  struct {
    uint8_t  stepping[8];
    uint8_t  speedGrade[4];
    uint16_t device;
    uint8_t  tempGrade;
    uint8_t  _reserved1;
  } fpga;
	uint8_t  pcbRev;
	uint8_t  _reserved1[2];
  uint8_t  checksum;      /* This MUST ALWAYS be the last member in the struct */
} VpdAdpexrc5tRev0;
#pragma pack()

/* Values for VpdAdmxrc6t1Rev0::fpga::tempGrade */
#define ADPEXRC5T_VPD_TEMPGRADE_COMMERCIAL  (0)
#define ADPEXRC5T_VPD_TEMPGRADE_INDUSTRIAL  (1)
#define ADPEXRC5T_VPD_TEMPGRADE_EXTENDED    (2)

/* Fields for ModelRegsAdmxrc6tx::intCtl */
#define ADPEXRC5T_V_INTCTL_LEVELBITS (0)

#endif
