/*
** File: admxpl_common.h  
** Project: ADB1 core driver
** Purpose: Definitions for ADB1 common routines for models:
**   o ADM-XPL
**   o ADM-XP
**   o ADP-XPI
**
** (C) Copyright Alpha Data 2013
*/

#ifndef _ADATA_CORE_ADMXPL_COMMON_H
#define _ADATA_CORE_ADMXPL_COMMON_H

#include "device.h"
#include "adb1.h"

extern void
admxplFlash(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int bankIndex,
  boolean_t bWrite,
  uint64_t location,
  uint32_t* pValue);

extern void
admxplFlashReset(
  Adb3CoreDeviceContext* pDevCtx);

extern FpgaControlStatus
admxplFpgaControl(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int index,
  CoreFpgaControlOp opCode,
  uint32_t* pFpctlShadow,
  boolean_t* pbValue);

extern FpgaSelectMapStatus
admxplFpgaSelectMap(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int index,
  boolean_t bWrite,
  size_t length,
  void* pBuffer);

extern boolean_t
admxplHandleInterrupt(
  Adb3CoreDeviceContext* pDevCtx,
  uint32_t gmask,  /* Bitmask of enabled generic interrupts */
  uint32_t mmask); /* Bitmask of model-specific interrupts */

extern boolean_t
admxplMapBusResources(
  Adb3CoreDeviceContext* pDevCtx,
  DfBusResources* pRaw,
  DfBusResources* pTranslated,
  boolean_t bUnmap);

extern boolean_t
admxplValidateBusResources(
  Adb3CoreDeviceContext* pDevCtx,
  DfBusResources* pRaw,
  DfBusResources* pTranslated);

extern CoreVpdStatus
admxplReadWriteVpd(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bWrite,
  size_t address,
  size_t length,
  void* pData);

extern CoreVpdStatus
admxplSyncVpd(
	Adb3CoreDeviceContext* pDevCtx);

#endif
