#if !defined(_ADATA_PORTABLE_FILE_H)
#define _ADATA_PORTABLE_FILE_H

/*
** File: portable_file.h  
** Project: API libraries
** Purpose: Defines portability functions used by API libraries
**
** (C) Copyright Alpha Data 2011
*/

#include <portability.h>

extern portable_file_t
portableFileOpenA(
  const char* pFileName,
  bool_t bWrite);

extern portable_file_t
portableFileOpenW(
  const wchar_t* pFileName,
  bool_t bWrite);

extern void
portableFileClose(
  portable_file_t hFile);

extern bool_t
portableFileGetSize(
  portable_file_t hFile,
  uint64_t* pSize);

extern bool_t
portableFileRead(
  portable_file_t hFile,
  void* pBuffer,
  uint64_t n,
  uint64_t* pNumRead);

extern bool_t
portableFileSetPointer(
  portable_file_t hFile,
  uint64_t offset);

#endif
