#ifndef _ADATA_API_ADMXRC2_PLATFORM_H
#define _ADATA_API_ADMXRC2_PLATFORM_H

/*
** File: admxrc2_platform.h  
** Project: ADMXRC2 API module library
** Purpose: Interface to Linux-specific functions for ADMXRC2 API module library
**
** (C) Copyright Alpha Data 2013
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <wchar.h>
#include <ctype.h>
#include <linux/ioctl.h>

#include <portability.h>

#include <admxrc2/platform.h>
#include <admxrc2/status.h>

#define ADMXRC2_HAS_USER_EVENT_HANDLE PORTABLE_HAS_USER_EVENT_HANDLE

extern ADMXRC2_STATUS
admxrc2OpenDevice(
  unsigned int index,
  int bUnprivileged,
  ADMXRC2_HANDLE* phDevice);

extern ADMXRC2_STATUS
admxrc2CloseDevice(
  ADMXRC2_HANDLE hDevice);

#define admxrc2Ioctl(hDevice, code, pIoctl, hEvent, sizeIn, sizeOut) _admxrc2Ioctl(hDevice, code, pIoctl, sizeIn, sizeOut)

extern ADMXRC2_STATUS
_admxrc2Ioctl(
  ADMXRC2_HANDLE hDevice,
  unsigned int code,
  void* pIoctl,
  unsigned int sizeIn,
  unsigned int sizeOut);

extern ADMXRC2_STATUS
admxrc2MapRegion(
  ADMXRC2_HANDLE hCard,
  unsigned int regionTag,
  uint64_t offset,
  uint64_t length,
  void** ppVirtualBase);

extern ADMXRC2_STATUS
admxrc2UnmapRegion(
  ADMXRC2_HANDLE hCard,
  void* pVirtualBase);

extern void
admxrc2UnmapAllRegions(
  ADMXRC2_HANDLE hCard);

extern ADMXRC2_STATUS
admxrc2FindRegion(
  ADMXRC2_HANDLE hAdmxrc2,
  unsigned int regionTag,
  unsigned int ordinal,
  void** ppVirtualBase,
  uint64_t* pOffset,
  uint64_t* pLength);

#endif
