/*
* Title:	TmsStateMainWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	The main test Gui window
*
* Mod Rec:
*
*/

#ifndef	TmsStateMainWin_H
#define TmsStateMainWin_H	1


#include <AppGui.h>
#include <BError.h>
#include <BString.h>
#include <TmsStateGui.h>
#include <TmsCycleParam.h>
#include <qtabwidget.h>

class TmsStateMainWin: public AppGui {
	Q_OBJECT
public:
	TmsStateMainWin();
	~TmsStateMainWin();

	void	warningDialog(BString title,BError err,BString msg = "");	///< Warning dialog
public slots:
	void	slotQuit();				///< Exit the application

private slots:
	void	slotEnterWhatsThis();			///< Enter Whats This mode
	void	slotAbout();				///< Display the About dialog
	void	slotManual();				///< Display the online manual
	void	slotTmsManual();			///< Didplay Tms System Manual index
private:
	void	initMenubar();				///< Initialize menu bar
	void	initMain();				///< Initialize main widget
	void	initToolbar();				///< Initialize main widget

	QTabWidget*		otabd;			///< Tab widget controlling other widget panes
	TmsStateGui*		ostateGui;
	Tms::CycleParamEdit	ocycleParam;
};
#endif
