/*
* Title:	tmsControlMainGui.cpp 
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Primary interface for Cern TMS system test/debug Gui
*
* Mod Rec:
*
*/

#include <qmenubar.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qinputdialog.h>
#include <qimage.h>

#include <TmsStateMainWin.h>
#include <BFile.h>
#include <unistd.h>
#include <math.h>
#include <main.h>

const int	nGraphs = 7;

TmsStateMainWin::TmsStateMainWin(){
}

TmsStateMainWin::~TmsStateMainWin(){
}

void TmsStateMainWin::initMenubar(){
	QPopupMenu*	m;
	QAction*	a;
	
	m = new QPopupMenu();
	a = addAction(m, tr("Quit"), tr("&Quit"), tr("Ctrl+Q"), SLOT(slotQuit()), tr("Quits the application"));
	menuBar()->insertItem(tr("&File"), m);

        menuBar( )->insertSeparator(-1);
	m = new QPopupMenu();
//	a = addAction(m, tr("Whats This"), tr("&Whats This"), tr("Ctrl+W"), SLOT(slotEnterWhatsThis()), tr("Enter Whats This mode"));
	a = addAction(m, tr("Manual"), tr("&Manual"), tr("Ctrl+M"), SLOT(slotManual()), tr("Online Manual"));
	a = addAction(m, tr("TMS Manual"), tr("&TMS Manual"), tr("Ctrl+T"), SLOT(slotTmsManual()), tr("TMS System Manual"));
	a = addAction(m, tr("About"), tr("&About"), tr("Ctrl+A"), SLOT(slotAbout()), tr("About the program"));
	menuBar()->insertItem(tr("&Help"), m);
//	setMinimumSize(QSize(1024,850));
}

void TmsStateMainWin::initMain(){
	BError		err;
	QFont		f;
	QStatusBar*	wstatusBar;
	
	otabd     	= new QTabWidget(this);

	setCentralWidget(otabd);
	otabd->setName("Tab Widget");
	otabd->setMinimumSize(1000,860);
	otabd->setTabPosition(QTabWidget::Bottom);

	ostateGui = new TmsStateGui();
	ostateGui->init();

	otabd->addTab(ostateGui, "Data View");
	otabd->show();

	f = qApp->font();
	f.setPointSize(10);
	qApp->setFont(f,true);
	
	wstatusBar = statusBar();

	ocycleParam.readFromFile(fileName);
	ostateGui->slotView(ocycleParam);
}

void	TmsStateMainWin::slotQuit() {
	exit(0);
}

void	TmsStateMainWin::initToolbar() {
}


void	TmsStateMainWin::slotEnterWhatsThis() {
	whatsThis();
}

void	TmsStateMainWin::warningDialog(BString title,BError err,BString msg){
	BString	m;
	
	m = BString("<h5>") + title + "</h5><p>" + msg + "<br>" + err.getString() + "</p>";
	QMessageBox::warning(this, "tmsControlGui - Warning", m.retStr());
}

void TmsStateMainWin::slotAbout() {
	BString		msg;
	QImage		logo("alphadata_beam_logo.png");
	QMessageBox	mbox(this);
	
	
	msg = "<p><b>tmsControlGui</b> - Trajectory Measurement System Test Interface</p>";
	msg += BString("<p>&copy; BEAM Ltd 2007</p><p>Version: ") + VERSION + "</p>";

	mbox.setIconPixmap(logo);
	mbox.setCaption("About");
	mbox.setText(msg.retStr());
	mbox.exec();
}

void TmsStateMainWin::slotManual() {
	BIter		i;
	BList<BString>	fnames;
	BString		fname;
	BString		cmd;
	
	fnames.append("/usr/tms/doc/TmsControlGui.pdf");
	fnames.append("./TmsControlGui.pdf");
	fnames.append("../doc/TmsControlGui.pdf");
	fnames.append("../../doc/TmsControlGui.pdf");

	for (fnames.start(i);! fnames.isEnd(i); fnames.next(i)) {
		if (access(fnames[i].retStr(),R_OK) == 0) {
			fname = fnames[i];
			break;
		}	
	}
	if (! fnames.isEnd(i)) {
		cmd =BString("firefox ") + fname + "&";
		system(cmd.retStr());
	}
	else {
		QMessageBox::warning(this, "Warning", "Unable to locate the help files");
	}
}




void TmsStateMainWin::slotTmsManual() {
	BIter		i;
	BList<BString>	fnames;
	BString		fname;
	BString		cmd;
	
	fnames.append("/usr/tms/doc/index.html");
	fnames.append("./index.html");
	fnames.append("../doc/index.html");
	fnames.append("../../doc/index.html");

	for (fnames.start(i);! fnames.isEnd(i); fnames.next(i)) {
		if (access(fnames[i].retStr(),R_OK) == 0) {
			fname = fnames[i];
			break;
		}	
	}
	if (! fnames.isEnd(i)) {
		cmd =BString("firefox ") + fname + "&";
		system(cmd.retStr());
	}
	else {
		QMessageBox::warning(this, "Warning", "Unable to locate the help files");
	}
}





