/***************************************************************************
 *	TmsStateGui.h	TMS Cycle parameters State display
 *			T.Barnaby,	BEAM Ltd,	2007-11-13
 ***************************************************************************
 */
#ifndef	TmsStateGui_H
#define TmsStateGui_H	1

#include <BError.h>
#include <BString.h>
#include <TmsCycleParam.h>
#include <BGraph.h>
#include <qvbox.h>
#include <qtabwidget.h>
#include <qspinbox.h>
#include <qtextview.h>
#include <qlineedit.h>

class TmsStateGui: public QVBox {
	Q_OBJECT
public:
	TmsStateGui();
	~TmsStateGui();

	void	init();					///< Initialise

public slots:
	BError	slotView(Tms::CycleParamEdit& cycleParam);
	void	slotUpdate();

private:
	QSpinBox*		ostate;
	QLineEdit*		ostateInfo;
	QLineEdit*		ostateField0;
	QLineEdit*		ostateField1;

	Tms::CycleParamEdit	ocycleParam;
	BArray<BGraph*>		ographs;
};
#endif
