/*
* Title:	StatusWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Configuration Data entry and control window
*
* Mod Rec:
*
*/


#ifndef STATUSWIN_H
#define STATUSWIN_H

#include <BWidgets.h>
#include <Control.h>
#include <BString.h>
#include <qtextedit.h>
#include <qtimer.h>

/*! Configure System and setup user interface window. 
*
*/
class StatusWin : public BHBox {
        Q_OBJECT
public:
        StatusWin(QWidget* w,Control& c);
	~StatusWin();

	void	showEvent(QShowEvent* event);		///< Update and make the widget visible
	void	hideEvent(QHideEvent* event);		///< Hide the widget stop automatic updates

private slots:
	void	updateTimed();				///< Get status and update 
	void	updateForced();				///< Force error reporting on. Get status and update 
private:
	void	getStatus();
	void	warningDialog(BString title, BError err);
	QTextEdit*		ostatus;
	QTimer*			oticker;		///< Update Poll timer
	int			owarningActive;		///< Indicates Warning dialog is active
	Control&		ocontrol;
};
#endif
