/*
* Title:	OptionsWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-14
*
* Contents:	Options Control and Dialogs. 
*
* Mod Rec:
*/

#ifndef OPTIONSWIN_H
#define OPTIONSWIN_H

#include <BWidgets.h>
#include <qdialog.h>
#include <Control.h>
#include <qlistwidget.h>
#include <qstackedwidget.h>
#include <qtabwidget.h>
#include <qcheckbox.h>
#include <qlineedit.h>

class DataOptions;

class	OptionsWin: public QDialog {
	Q_OBJECT
public:
      OptionsWin(QWidget* parent, Control& c);
      ~OptionsWin();
public slots:
	void	show();			///< Show the dialog
	void	accept();		///< Accept button clicked
	void	selected();		///< Option selected from the options list
private:
	QStackedWidget*	owidgetStack;
	DataOptions*	odataOptions;

	QListWidget*	olistBox;
	Control&	ocontrol;
};

class DataOptions : public QTabWidget {
	Q_OBJECT
public:
	DataOptions(QWidget* parent,Control& c);
	~DataOptions();

	void	set();
	void 	save();
private:
	Control&		ocontrol;
	QLineEdit*		odefaultServer;
};



#endif
