

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdint.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
typedef unsigned int DWORD; 

#include <admxrc2.h>

#include "common.h"


ADMXRC2_HANDLE		card = NULL;


int main(int argc, char *argv[])
{
  ADMXRC2_STATUS		status;
  ADMXRC2_CARD_INFO		cardInfo;
  Arguments			arguments;
  Option			options[3];
  ADMXRC2_SPACE_INFO	        spInfo;
  volatile DWORD*		fpgaSpace;
  
  int use64bit;
  char command[32];  
  unsigned int arg1,arg2,arg3;
  unsigned int buffer[16];
  int i;
  int nargin;
  int ret;
  unsigned int dmaMode;
 

  /* Set up expected options */
  options[0].key = "card";
  options[0].type = Option_uint;
  options[0].def.uintVal = 0;
  options[0].meaning = "ID of card to use";
  options[1].key = "index";
  options[1].type = Option_uint;
  options[1].def.uintVal = 0;
  options[1].meaning = "index of card to use";
  options[2].key = "64";
  options[2].type = Option_boolean;
  options[2].def.booleanVal = FALSE;
  options[2].meaning = "TRUE => Local Bus is 64 bit";

  arguments.nOption = 3;
  arguments.option = options;
  arguments.nParamType = 0;
  arguments.minNParam = 0;

  /* Parse command line */
  parse_command_line(
		     "lbdbg",
		     argc,
		     argv,
		     &arguments);



  if (options[0].specified && options[1].specified) {
    printf("Do not specify both /card and /index\n");
    ret = -1;
    goto done;
  }

  if (!options[1].specified) {
    ADMXRC2_CARDID cardID = options[0].value.uintVal;

    status = ADMXRC2_OpenCard(cardID, &card);
    if (status != ADMXRC2_SUCCESS) {
      printf("Failed to open card with ID %ld: %s\n",
	     (unsigned long) cardID, ADMXRC2_GetStatusString(status));
      ret = -1;
      goto done;
    }
  } else {
    unsigned int index = options[1].value.uintVal;

    status = ADMXRC2_OpenCardByIndex(index, &card);
    if (status != ADMXRC2_SUCCESS) {
      printf("Failed to open card with index %ld: %s\n",
	     (unsigned long) index, ADMXRC2_GetStatusString(status));
      ret = -1;
      goto done;
    }
  }

  status = ADMXRC2_GetCardInfo(card, &cardInfo);
  if (status != ADMXRC2_SUCCESS) {
    printf("Failed to get card info: %s\n", ADMXRC2_GetStatusString(status));
    ret = -1;
    goto done;
  }
 
  status = ADMXRC2_GetSpaceInfo(card, 0, &spInfo);
  if (status != ADMXRC2_SUCCESS) {
    printf("Failed to get space 0 info: %s\n",
	   ADMXRC2_GetStatusString(status));
    ret = -1;
    goto done;
  }
  fpgaSpace = (volatile DWORD*) spInfo.VirtualBase;


  /* Set Space Config */
  use64bit = options[2].value.booleanVal;
  if (use64bit)
    ADMXRC2_SetSpaceConfig(card, 0, ADMXRC2_SPACE_SET_WIDTH | ADMXRC2_SPACE_WIDTH_64);
  else
    ADMXRC2_SetSpaceConfig(card, 0, ADMXRC2_SPACE_SET_WIDTH | ADMXRC2_SPACE_WIDTH_32);
  
  dmaMode = ADMXRC2_BuildDMAModeWord(
				     cardInfo.BoardType,
				     use64bit ? ADMXRC2_IOWIDTH_64 : ADMXRC2_IOWIDTH_32,
				     0,
				     ADMXRC2_DMAMODE_USEREADY | ADMXRC2_DMAMODE_USEBTERM | ADMXRC2_DMAMODE_BURSTENABLE);



  while (1)
    {
      printf(">");
      nargin = scanf(" %s",&command);
      
      if ((command[0]=='q') ||(command[0]=='Q'))
	break;

      if ((command[0]=='d') ||(command[0]=='D'))
	{
	  scanf(" %x",&arg1);
	  ADMXRC2_DoDMAImmediate(card,buffer,64,arg1,ADMXRC2_LOCALTOPCI,0,dmaMode,0,NULL,NULL);

	  if (use64bit)
	    for (i=0;i<8;i++)
	      printf("%6.6x %8.8x %8.8x\n",arg1+i*8,buffer[i*2+1],buffer[i*2]);
	  else
	    for (i=0;i<16;i++)
	      printf("%6.6x %8.8x\n",arg1+i*4,buffer[i]);
	}
      
      if ((command[0]=='m') ||(command[0]=='M'))
	{
	  scanf(" %x",&arg1);	  
	  if (use64bit)
	    {
	      scanf(" %x %x",&arg2,&arg3);
	      buffer[1]=arg2;
	      buffer[0]=arg3;
	      ADMXRC2_DoDMAImmediate(card,buffer,8,arg1,ADMXRC2_PCITOLOCAL,0,dmaMode,0,NULL,NULL);
	      printf("%6.6x %8.8x %8.8x\n",arg1,buffer[1],buffer[0]);
	    }
	  else
	    {
	      scanf(" %x",&arg2);
	      buffer[0] = arg2;
	      memcpy((void*)(fpgaSpace+(arg1/4)),buffer,4);
	    }
	}

      if ((command[0]=='r') ||(command[0]=='R'))
	{
	  int 	data;
	  data = 1;
	  ADMXRC2_Write(card,ADMXRC2_IOWIDTH_32,ADMXRC2_IOADAPTER,0x28,&data,4);
	  usleep(1);
	  data = 0;
	  ADMXRC2_Write(card,ADMXRC2_IOWIDTH_32,ADMXRC2_IOADAPTER,0x28,&data,4);
	  usleep(1);
	  printf("Resetting Card\n");
	  break;
	}

	  /* Pulse the PROG pin to clear the FPGA */
     if ((command[0]=='c') ||(command[0]=='C'))
	{
	  int 	data;
	  data = 1;
	  ADMXRC2_Write(card,ADMXRC2_IOWIDTH_32,0,0x80000C,&data,4);
	  usleep(20);
	  data = 0;
	  ADMXRC2_Write(card,ADMXRC2_IOWIDTH_32,0,0x80000C,&data,4);
	  usleep(1);
	  printf("Clearing FPGA\n");
	  break;
	}

    }


 done:
  if (card != NULL) {
    ADMXRC2_CloseCard(card);
  }

  return ret; 
}
