/*******************************************************************************
 *	TmsS.h	Produced by Bidl
 *******************************************************************************
 */

#ifndef TMSS_H
#define TMSS_H 1

#include <stdint.h>
#include <Boap.h>
#include <BString.h>

#include <TmsC.h>

namespace Tms {
	class PuControlService : public BoapServiceObject {
	public:
			PuControlService(BoapServer& server, BString name);
		BError dogetVersion(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getVersion(BString& version) = 0;
		BError doinit(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError init() = 0;
		BError dosetProcessPriority(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setProcessPriority(UInt32 priority) = 0;
		BError doconfigure(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError configure(ConfigInfo configInfo) = 0;
		BError dosetControlInfo(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setControlInfo(CycleParam params) = 0;
		BError dosetNextCycle(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setNextCycle(UInt32 cycleNumber, BString cycleType) = 0;
		BError dotest(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError test(BList<BError>& errors) = 0;
		BError dogetStatus(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getStatus(BList<NameValue>& statusList) = 0;
		BError dogetStatistics(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getStatistics(BList<NameValue>& statsList) = 0;
		BError dosetTestMode(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setTestMode(PuChannel puChannel, UInt32 testOutput, UInt32 timingDisableMask) = 0;
		BError dosetTimingSignals(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setTimingSignals(PuChannel puChannel, UInt32 timingSignals) = 0;
		BError docaptureTestData(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError captureTestData(PuChannel puChannel, TestCaptureInfo captureInfo, BArray<UInt64>& data) = 0;
		BError dosetTestData(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setTestData(PuChannel puChannel, Int32 on, BArray<UInt32> data) = 0;
		BError dosetPupeConfig(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig) = 0;
		BError dogetPupeConfig(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig) = 0;
	};
	class PuProcessService : public BoapServiceObject {
	public:
			PuProcessService(BoapServer& server, BString name);
		BError dogetVersion(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getVersion(BString& version) = 0;
		BError dogetStatus(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getStatus(PuChannel puChannel, PuStatus& puStatus) = 0;
		BError dogetData(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getData(PuChannel puChannel, DataInfo dataInfo, Data& data) = 0;
		BError doaddEventServer(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError addEventServer(BString name) = 0;
		BError dorequestData(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError requestData(PuChannel puChannel, DataInfo dataInfo) = 0;
	};
	class TmsControlService : public BoapServiceObject {
	public:
			TmsControlService(BoapServer& server, BString name);
		BError dogetVersion(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getVersion(BString& version) = 0;
		BError dosetProcessPriority(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setProcessPriority(UInt32 priority) = 0;
		BError doinit(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError init() = 0;
		BError doconfigure(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError configure(ConfigInfo configInfo) = 0;
		BError dogetConfiguration(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getConfiguration(ConfigInfo& configInfo) = 0;
		BError dosetControlInfo(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setControlInfo(CycleParam params) = 0;
		BError dogetControlInfo(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getControlInfo(BString cycleType, UInt32 puChannel, CycleParam& params) = 0;
		BError dodelControlInfo(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError delControlInfo(BString cycleType, UInt32 puChannel) = 0;
		BError dogetControlList(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getControlList(BList<CycleParamItem>& itemList) = 0;
		BError dosetNextCycle(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setNextCycle(UInt32 cycleNumber, BString cycleType) = 0;
		BError dotest(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError test(BList<BError>& errors) = 0;
		BError dogetStatus(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getStatus(BList<NameValue>& statusList) = 0;
		BError dogetStatistics(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getStatistics(BList<NameValue>& statsList) = 0;
		BError dogetPuChannel(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getPuChannel(UInt32 puChannel, PuChannel& puPhysChannel) = 0;
		BError dosetTestMode(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setTestMode(PuChannel puPhysChannel, UInt32 testOutput, UInt32 timingDisableMask) = 0;
		BError dosetTimingSignals(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setTimingSignals(PuChannel puPhysChannel, UInt32 timingSignals) = 0;
		BError docaptureTestData(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError captureTestData(PuChannel puPhysChannel, TestCaptureInfo captureInfo, BArray<UInt64>& data) = 0;
		BError dosetTestData(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setTestData(PuChannel puPhysChannel, Int32 on, BArray<UInt32> data) = 0;
		BError dosetPupeConfig(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig) = 0;
		BError dogetPupeConfig(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig) = 0;
		BError dopuServerStarted(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError puServerStarted(UInt32 number) = 0;
	};
	class TmsProcessService : public BoapServiceObject {
	public:
			TmsProcessService(BoapServer& server, BString name);
		BError dogetVersion(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getVersion(BString& version) = 0;
		BError dogetCycleInfo(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getCycleInfo(UInt32& cycleNumber, BString& cycleType) = 0;
		BError dogetData(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError getData(DataInfo dataInfo, Data& data) = 0;
		BError doaddEventServer(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError addEventServer(BString name) = 0;
		BError dorequestData(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError requestData(DataInfo dataInfo) = 0;
	};
	class TmsEventService : public BoapServiceObject {
	public:
			TmsEventService(BoapServer& server, BString name);
		BError doerrorEvent(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError errorEvent(UInt32 cycleNumber, BError error) = 0;
		BError docycleStartEvent(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError cycleStartEvent(UInt32 cycleNumber) = 0;
		BError docycleStopEvent(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError cycleStopEvent(UInt32 cycleNumber) = 0;
		BError dodataEvent(BoapServerConnection* conn, BoapPacket& rx, BoapPacket& tx);
		virtual BError dataEvent(DataInfo dataInfo) = 0;
	};
}
#endif
