/*******************************************************************************
 *	TmsD.h	Produced by Bidl
 *******************************************************************************
 */

#ifndef TMSD_H
#define TMSD_H 1

#include <Boap.h>

#include <BList.h>
#include <BArray.h>

//*****************************************************************************/
//	Base objects for BEAM TMS System
//			T.Barnaby,	BEAM Ltd,	2006-12-07
//*****************************************************************************/
//
namespace Tms {
	enum Errors 	{ ErrorOk, ErrorMisc, ErrorWarning, ErrorInit, ErrorConfig, ErrorParam, ErrorNotImplemented, ErrorComms, ErrorCommsTimeout, ErrorMC, ErrorFpga, ErrorStateTable, ErrorCycleNumber, ErrorDataNotAvailable, ErrorDataGone, ErrorDataFuture, ErrorTimeout};

	enum CyclePeriod 	{ CyclePeriodStart, CyclePeriodCalibration, CyclePeriodHarmonic0, CyclePeriodHarmonic1, CyclePeriodHarmonic2, CyclePeriodHarmonic3, CyclePeriodHarmonic4, CyclePeriodHarmonic5, CyclePeriodHarmonic6, CyclePeriodHarmonic7};

	enum DataFunction 	{ DataFunctionRaw, DataFunctionMean0, DataFunctionMean1};

	enum TestOutput 	{ TestOutputFrefLocal, TestOutputPllL1, TestOutputPllL2};

	enum Priority 	{ PriorityLow, PriorityNormal, PriorityHigh};

	class NameValue {
	public:
		NameValue();
		NameValue(BString pname, BString pvalue);
	public:
		BString	name;	///< The Name of the value
		BString	value;	///< The actual value in string form
	};

	/// This class stores a Physical Pick-Up channel id
	class PuChannel {
	public:
		PuChannel();
		PuChannel(UInt8 pmoduleNum, UInt8 ppupeNum, UInt8 ppupeChan);
	public:
		UInt8	moduleNum;	///< The Module number
		UInt8	pupeNum;	///< The PUPE number
		UInt8	pupeChan;	///< The PUPE channel
	};

	/// This class stores the status of an individual Pick-Up
	class PuStatus {
	public:
		PuStatus();
		PuStatus(Int32 prunning, BError perror);
	public:
		Int32	running;	///< ThePickUpiscurrentlyrunning.
		BError	error;	///< ThePickUp'scurrenterrorstatus.
	};

	/// This class describes the configuration of the TMS
	class ConfigInfo {
	public:
		ConfigInfo();
		ConfigInfo(BArray<PuChannel> ppuReferences);
	public:
		BArray<PuChannel>	puReferences;	///< The logical to physical Pick-Up table. Each PuReference includes a Module Controller identifier, a Physical Pick-Up number and a Physical Channel.
	};

	/// This class defines the data to be acquired and/or fetched
	class DataInfo {
	public:
		DataInfo();
		DataInfo(UInt32 pcycleNumber, UInt32 pchannel, UInt32 pcyclePeriod, UInt32 pstartTime, UInt32 porbitNumber, UInt32 pbunchNumber, UInt32 pfunction, UInt32 pargument, UInt32 pnumValues, Int32 plimitData);
	public:
		UInt32	cycleNumber;	///< The PS Cycle number
		UInt32	channel;	///< The pick-up channel number
		UInt32	cyclePeriod;	///< The cycle period the data is from
		UInt32	startTime;	///< The start time in milli-seconds in the cycle period (starting from 0)
		UInt32	orbitNumber;	///< The starting orbit number (starting from 0)
		UInt32	bunchNumber;	///< The Bunch number (starting from 1 (0 is all bunches))
		UInt32	function;	///< The data processing function to perform or performed. (0 normal data)
		UInt32	argument;	///< The Argument to the data processing function
		UInt32	numValues;	///< The total number of data points to return
		Int32	limitData;	///< If set limits the data to that within the period
	};

	/// This is the definition of a single data value
	class DataValue {
	public:
		DataValue();
		DataValue(Int16 psigma, Int16 pdeltaX, Int16 pdeltaY, Int16 ptimeMs);
	public:
		Int16	sigma;	///< The Sigma value
		Int16	deltaX;	///< The DeltaX value
		Int16	deltaY;	///< The DeltaY value
		Int16	timeMs;	///< The Time in ms this sample was processed
	};

	/// This class stores the raw data
	class Data {
	public:
		Data();
		Data(UInt32 pnumValues, UInt32 pdataType, UInt32 pnumBunches, UInt32 pnumChannels, BArray<DataValue> pdataValues);
	public:
		UInt32	numValues;	///< The total number of data samples
		UInt32	dataType;	///< The type of data in the data block
		UInt32	numBunches;	///< The number of bunches
		UInt32	numChannels;	///< The number of channels
		BArray<DataValue>	dataValues;	///< The data
	};

	/// This class defines the Pick-Up state table
	class PuStateTable {
	public:
		PuStateTable();
		PuStateTable(UInt32 pstate, UInt32 pharmonic, UInt32 pnumBunches, BArray<UInt8> pphaseTable);
	public:
		UInt32	state;	///< The State table entry
		UInt32	harmonic;	///< The harmonic number for this state
		UInt32	numBunches;	///< The number of bunches to capture
		BArray<UInt8>	phaseTable;	///< The Phase table for this state
	};

	/// This class defines the parameters for a PS processing cycle
	class CycleParam {
	public:
		CycleParam();
		CycleParam(BString pcycleType, BString pinfo, UInt32 pchannel, UInt32 ppllInitialFrequency, UInt32 ppllInitialFrequencyDelay, UInt32 ppllFrefGain, UInt32 ppllGain, UInt32 ppllDdsMinimum, UInt32 ppllDdsMaximum, BArray<Int32> pfrefPhaseDelay, BArray<PuStateTable> pstateTable, BArray<BString> psettings);
	public:
		BString	cycleType;	///< The Cycle Type Name of this parameter set, normally the BEAM type the set of parameters is designed to measure
		BString	info;	///< Information on this parameter set
		UInt32	channel;	///< The channel number this configuration is for, 0 defines all channels
		UInt32	pllInitialFrequency;	///< ThisdefinestheinitialPLLfrequency.Thisisloadedon START_CYCLEandafterthedelaygivenin pllInitialFrequencyDelay.
		UInt32	pllInitialFrequencyDelay;	///< ThisdefinesthedelayinmillisecondsfromSTART_CYCLE whenthepllInitialFrequencyisloaded.
		UInt32	pllFrefGain;	///< ThegaintheFREF signal. This is a value in the range +-8191. A normal value would be around 4096.
		UInt32	pllGain;	///< ThegainofthePLLfeedbacksystem. This is the gain reduction of the PLL in terms of right bit shifts. A bit shift of 7 is about unity gain.
		UInt32	pllDdsMinimum;	///< PLLDDSminimumfrequency. If this and pllDdsMaximum is set to 0, this feature is disabled.
		UInt32	pllDdsMaximum;	///< PLLDDSmaximumfrequency. If this and pllDdsMinimum is set to 0, this feature is disabled.
		BArray<Int32>	frefPhaseDelay;	///< The phase delay parameters for the Fref timing signal for each of the Pick-Up channels. This is set based on the position of the Pick-Up's in the PS ring. Its value is based of Fref / 512.
		BArray<PuStateTable>	stateTable;	///< ThearrayofStateTableentriesfortheprocessingrun.
		BArray<BString>	settings;	///< A string array defining the settings for the states. Used for CycleParam editors
	};

	// This class is used to return the list of CycleParm's
	class CycleParamItem {
	public:
		CycleParamItem();
		CycleParamItem(BString pcycleType, UInt32 pchannel);
	public:
		BString	cycleType;	///< The Cycle Type Name of this parameter set, normally the BEAM type the set of parameters is designed to measure
		UInt32	channel;	///< The channel number this configuration is for, 0 defines all channels
	};

	/// This class defines the parameters for a test data capture
	class TestCaptureInfo {
	public:
		TestCaptureInfo();
		TestCaptureInfo(UInt32 psource, UInt32 pclock, UInt32 pstartTime, UInt32 ppostTriggerDelay, UInt32 ptriggerMask, Int32 ptriggerAnd, Int32 ptriggerStore, Int32 ptriggerSourceData);
	public:
		UInt32	source;	///< The source data (0  - 3)
		UInt32	clock;	///< The Clock source
		UInt32	startTime;	///< The start time in ms from CYCLE_START before trigger is activated
		UInt32	postTriggerDelay;	///< The delay, in clock cycles, after the trigger before capture starts
		UInt32	triggerMask;	///< The Trigger bit mask. This is the bit mask of the 8 timing signals
		Int32	triggerAnd;	///< The Trigger function is an AND rather than an OR
		Int32	triggerStore;	///< Store the trigger in the upper 8 data bits
		Int32	triggerSourceData;	///< Use lower 32bits of data as trigger source rather than timing signals
	};

	// Special PUPE configuration for test purposes
	class PupeConfig {
	public:
		PupeConfig();
		PupeConfig(UInt32 pinternalTimingMask, Int32 padcSysclkSync, Int32 pdisableBlr);
	public:
		UInt32	internalTimingMask;	///< Use internal, software/hardware generated, timing signals for the given signals.
		Int32	adcSysclkSync;	///< Sets the ADC clock to be synchronised with the SYSCLK timing clock
		Int32	disableBlr;	///< Disable the BLR algorithm
	};

	/// This interface provides functions to control, test and get statistics from an individual pick-up
	//
	/// This interface provides functions to configure and capture data from individual pick-up
	//
	/// This interface provides functions to control, test and get statistics from the TMS as a whole
	//
	/// This interface provides functions to capture data from the TMS as a whole
	//
	/// This interface provides functions for events to be sent to clients from the TMS as a whole
	//
}
#endif
