/*******************************************************************************
 *	TmsControlClient1.cpp	TMS API example code
 *			T.Barnaby,	BEAM Ltd,	2007-02-07
 *******************************************************************************
 *
 *	This is a very basic example of using the TmsApi from a clients perspective.
 *	It is designed to give an overview of using the API.
 */
#include <iostream>
#include <stdio.h>
#include <TmsLib.h>
#include <TmsCycleParam.h>

using namespace Tms;
using namespace std;

const UInt32	tmsStateNum = 16;
const UInt32	tmsPickupNum = 40;

// Initialise and test the TMS system
BError tmsTest(TmsControl& tmsControl, TmsProcess& tmsProcess){
	BError			err;
	BIter			i;
	BList<CycleParamItem>	itemList;
	CycleParamEdit		param;
	TmsCycleParams		tmsParams;
	BString			str;
		
	// Get Cycle Param List
	if(err = tmsProcess.getControlList(itemList)){
		return err.set(1, BString("Error: getting Cycle Parameter List: ") + err.getString());
	}
	
	for(itemList.start(i); !itemList.isEnd(i); itemList.next(i)){
		cout << "CycleType: " << itemList[i].cycleType << " Channel: " << itemList[i].channel << "\n";
	}
	
	// Get the first one and display its contents
	if(err = tmsProcess.getControlInfo(itemList.front().cycleType, itemList.front().channel, param)){
		return err.set(1, BString("Error: getting Cycle Parameter: ") + err.getString());
	}
	
	cout << param.getString();

	return err;
}

int main(int argc, char** argv){
	BError			err;
	TmsControl		tmsControl("//localhost/tmsControl");
	TmsProcess		tmsProcess("//localhost/tmsProcess");

	// Initialise and test the TMS system. Normally carried out by a configuration
	// and test client program.
	if(err = tmsTest(tmsControl, tmsProcess)){	
		cerr << "Error: " << err.getString() << "\n";
		return 1;
	}

	return 0;
}
