/*******************************************************************************
 *	BSpi.cpp	BSpi class
 *	T.Barnaby,	Beam Ltd,	2012-11-12
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#include <BSpi.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <linux/spi/spidev.h>

BSpi::BSpi(){
	odev = -1;
}

BError BSpi::init(BString devName, BUInt speed, Mode mode, Bool csActive){
	BError	err;
	BUInt	m = mode;

	odevName = devName;

	if((odev = open(odevName, O_RDWR)) < 0)
		return err.set(ErrorMisc, "Unable to open BSpi device");

	if(csActive)
		m |= SPI_CS_HIGH;

	if(ioctl(odev, SPI_IOC_WR_MODE, &m) < 0){
		return err.set(ErrorMisc, "Error setting mode");
	}

	if(ioctl(odev, SPI_IOC_WR_MAX_SPEED_HZ, &speed) < 0){
		return err.set(ErrorMisc, "Error setting speed");
	}

#ifdef ZAP
	if(ioctl(odev, SPI_IOC_RD_MAX_SPEED_HZ, &speed) < 0){
		return err.set(ErrorMisc, "Error geting speed");
	}

	printf("BSpi actual Speed: %d\n", speed);
#endif

	return err;
}

BError BSpi::transact(BUInt8 dev, void* txBuf, int txLen, int pad, void* rxBuf, int rxLen){
	BError				err;
	struct spi_ioc_transfer		xfer[2];
	int				n = 0;

//	printf("BSpi::transact: TxLen: %d rxLen: %d\n", txLen, rxLen);
	memset(xfer, 0, sizeof(xfer));
	
	if(txLen){
		xfer[n].tx_buf = (__u64)txBuf;
		xfer[n].rx_buf = 0;
		xfer[n].len = txLen;
		xfer[n].delay_usecs = 0;
		n++;
	}

	if(rxLen){
		xfer[n].tx_buf = 0;
		xfer[n].rx_buf = (__u64)rxBuf;
		xfer[n].len = rxLen;
		n++;
	}

	if(ioctl(odev, SPI_IOC_MESSAGE(n), &xfer) < 0){
		return err.set(ErrorMisc, BString("Unable to RDWR BSpi device: ") + strerror(errno));
	}

	return err;
}
