/*******************************************************************************
 *	BFifoCirc.cpp	FIFO Buffer Class
 *			T.Barnaby,	BEAM Ltd,	2006-02-22
 *******************************************************************************
 */
#include <BFifoCirc.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/mman.h>

#if DEBUG
#define	dprintf(fmt, a...)       printf(fmt, ##a);
#else
#define	dprintf(fmt, a...)
#endif

BFifoCircPos::BFifoCircPos(uint32_t size) : osize(size), opos(0){
}

void BFifoCircPos::setSize(uint32_t size){
	osize = size;
}

void BFifoCircPos::set(uint32_t pos){
	opos = pos;
}

uint32_t BFifoCircPos::pos(){
	return opos;
}

void BFifoCircPos::increment(uint32_t numFifoSamples){
	opos = (opos + numFifoSamples) % osize;
}

uint32_t BFifoCircPos::difference(const BFifoCircPos& pos){
	if(opos >= pos.opos)
		return opos - pos.opos;
	else
		return osize - pos.opos + opos;
}

BFifoCircPos::operator int(){
	return opos;
}

void BFifoCircPos::operator+=(uint32_t numFifoSamples){
	increment(numFifoSamples);
}

int BFifoCircPos::operator==(const BFifoCircPos& pos){
	return(opos == pos.opos);
}

int BFifoCircPos::operator!=(const BFifoCircPos& pos){
	return(opos != pos.opos);
}



