/*******************************************************************************
 *	BEvent1.h	File Event class
 *			T.Barnaby,	BEAM Ltd,	2005-07-08
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BEvent1_H
#define BEvent1_H	1

#include <stdint.h>
#include <BError.h>

enum BEvent1Type { BEvent1TypeNone, BEvent1TypeInt, BEvent1TypeError };

/// \brief This class provides a base class for all event objects that can
/// be sent over the events interface.
class BEvent1 {
public:
			BEvent1(uint32_t type);
	virtual		~BEvent1();
	
	uint32_t	getType();

			// Implementation functions
	virtual BError	getBinary(void* data, uint32_t& size);
	virtual BError	setBinary(void* data, uint32_t& size);
private:
	uint32_t	otype;			///< The event type
};

class BEvent1Error : public BError, public BEvent1 {
public:
			BEvent1Error(int errNo = ErrorOk, BString errStr = "");
	BError		getBinary(void* data, uint32_t& size);
	BError		setBinary(void* data, uint32_t& size);
private:
};

/// \brief This class provides a base interface for sending events
/// via a pipe. This allows threads to send events that can be
/// picked up by the poll system call.
class BEvent1Pipe {
public:
			BEvent1Pipe();
			~BEvent1Pipe();
			
	void		clear();					///< Clear events pending
	BError		sendEvent(BEvent1* event);	///< Send an event
	BError		getEvent(BEvent1* event, int timeOutUs = -1);	///< Receive the event
	
	int		getReceiveFd();			///< returns the receive file descriptor for the poll system call
private:
	int		ofds[2];			///< File descriptors for pipe
};


/// \brief This class provides an interface for sending simple integer events
/// via a file descriptor. This allows threads to send events that can be
/// picked up by the poll system call.
class BEvent1Int {
public:
			BEvent1Int();
			~BEvent1Int();
			
	void		clear();					///< Clear events pending
	BError		sendEvent(int event);		///< Send an event
	BError		getEvent(int& event, int timeOutUs = -1);	///< Receive the event.
	
	int		getFd();
private:
	int		ofds[2];			///< File descriptors for pipe
};

#endif
