/*******************************************************************************
 *	BErrorTime.cc	BErrorTime Class
 *			T.Barnaby,	BEAM Ltd,	2010-05-26
 *******************************************************************************
 */
#include <BErrorTime.h>


BErrorTime::BErrorTime(int errNo, BTimeStamp errTime, BString errStr){
	set(errNo, errTime, errStr);
}

BErrorTime& BErrorTime::set(int errNo, BTimeStamp errTime , BString errStr){
	oerrNo = errNo;
	oerrTime = errTime;
	oerrStr = errStr;
	return *this;
}

BErrorTime& BErrorTime::clear(){
	set(None, BTimeStamp(), "");
	return *this;
}

int BErrorTime::getErrorNo() const {
	return oerrNo;
}

BTimeStamp BErrorTime::getTime() const {
	return oerrTime;
}

BString BErrorTime::getString() const {
	return oerrStr;
}

BErrorTime BErrorTime::copy() {
	return BErrorTime(oerrNo, oerrTime, oerrStr.copy());
}

BErrorTime::operator int () const {
	return oerrNo;
}
