/*******************************************************************************
 *	GenBoapMcComms.h	Generate output
 *			T.Barnaby,	BEAM Ltd,	2/5/03
 *******************************************************************************
 */
#ifndef GenBoapMcComms_H
#define GenBoapMcComms_H

#include <Gen.h>

class GenBoapMcComms : public Gen {
public:
			GenBoapMcComms();
			~GenBoapMcComms();
	BError		produce(Node* n, BString fileName);
private:
	BError		produceHeaderInt();
	BError		produceTrailerInt();
	BError		produceHeaderImp();

	void		produceInt(Node* n, int serve);
	void		produceImp(Node* n, int serve);

	void		produceFuncC(Node* n);
	void		produceFuncSwitch(Node* n);
	void		produceFuncServe(Node* n);
	
	BString		getTypeSwapList(Node* n);

	BString		ofileName;
	FileIndent	ofileInt;
	FileIndent	ofileImp;
	BString		omodule;
	BString		ointerface;
	int		ofuncNum;
	int		opushPopDepth;
	int		oapiVersion;
};

#endif
