/*******************************************************************************
 *	GenBoapMc.cc	Boap output
 *			T.Barnaby,	BEAM Ltd,	2/5/03
 *******************************************************************************
 */
#define	DEBUG	1

#include <stdio.h>
#include <stdarg.h>
#include <strings.h>
#include <GenBoapMc.h>
#include <bidl.h>

void GenBoapMc::produceIntC(Node* n){
	BIter		i;
	BString		s;
	BString		c;
	BList<Node*>*	nl;

	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = n->name();
		ofileIntC.writeLine(BString("namespace ") + omodule + " {\n");
		ofileIntC.indentMore();

		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceIntC(n->nodes()[i]);
		}
		ofileIntC.indentLess();
		ofileIntC.writeLine("}\n");
		break;
	case Node::TINTERFACE:
		ointerface = n->name();
		// Client
		ofileIntC.writeLine(BString("class ") + ointerface + " : public BoapMcClientObject {\n");
		ofileIntC.writeLine("public:\n");
		ofileIntC.indentMore();
		ofileIntC.writeLine(BString("\t") + ointerface + "(BComms& comms);\n");
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceIntC(n->nodes()[i]);
		}
		ofileIntC.indentLess();
		ofileIntC.writeLine("private:\n");
		ofileIntC.writeLine("};\n");
		break;
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceIntC(n->nodes()[i]);
		}
		break;
	case Node::TFUNC:
		if(getTypeName(n->node(0)) == "oneway"){
			s = s + "void ";
		}
		else {
			s = s + getTypeName(n->node(0)) + " ";
		}
		s = s + n->name() + "(";
		nl = &n->node(1)->nodes();
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			if(i != nl->begin())
				s = s + ", ";
			if(nl->get(i)->node(0)->name() == "in"){
//				s = s + getTypeName(nl->get(i)->node(1)) + " ";
				s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			else if(nl->get(i)->node(0)->name() == "inref"){
				s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			else {
				s = s + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			s = s + nl->get(i)->node(2)->name();
		}
		s = s + ");";
		if(n->node(2) && n->node(2)->nodeType() == Node::TCOMMENT)
			s = s + "\t//" + n->node(2)->name();
		ofileIntC.writeLine(s + "\n");
		break;
	case Node::TCOMMENT:
		s = BString("//") + n->name() + "\n";
		ofileIntC.writeLine(s);
		break;
	case Node::TAPIVERSION:
		oapiVersion = n->name().retInt();
		break;
	default:
		break;
	}
}

void GenBoapMc::produceIntS(Node* n){
	BIter		i;
	BString		s;
	BString		sa;
	BList<Node*>*	nl;

	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = n->name();
		ofileIntS.writeLine(BString("namespace ") + omodule + " {\n");
		ofileIntS.indentMore();
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceIntS(n->nodes()[i]);
		}
		ofileIntS.indentLess();
		ofileIntS.writeLine("}\n");
		break;
	case Node::TINTERFACE:
		ointerface = n->name();
		// Server
		ofileIntS.writeLine(BString("class ") + ointerface + "Service : public BoapMcServiceObject {\n");
		ofileIntS.writeLine("public:\n");
		ofileIntS.indentMore();
		ofileIntS.writeLine(BString("\t") + ointerface + "Service();\n");
		ofileIntS.writeLine(BString("BError\tprocessPacket(BoapMcPacket& rx, BoapMcPacket& tx);\n\n"));
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceIntS(n->nodes()[i]);
		}
		ofileIntS.indentLess();
		ofileIntS.writeLine("};\n");
		break;
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceIntS(n->nodes()[i]);
		}
		break;
	case Node::TSTRUCT:
		break;
	case Node::TFUNC:
		s = "virtual ";
		if(getTypeName(n->node(0)) == "oneway"){
			s = s + "void ";
		}
		else {
			s = s + getTypeName(n->node(0)) + " ";
		}
		s = s + n->name() + "(";

		if(ooptions.hasKey("connectionClass")){
			sa = sa + ooptions["connectionClass"] + "* conn";
		}
		
		nl = &n->node(1)->nodes();
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			if(sa.len())
				sa = sa + ", ";
			if(nl->get(i)->node(0)->name() == "in"){
				sa = sa + getTypeName(nl->get(i)->node(1)) + " ";
			}
			else if(nl->get(i)->node(0)->name() == "inref"){
				sa = sa + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			else {
				sa = sa + getTypeName(nl->get(i)->node(1)) + "& ";
			}

			sa = sa + nl->get(i)->node(2)->name();
		}
		s = s + sa + ") = 0;\n";
		ofileIntS.writeLine(s);
		break;
	default:
		break;
	}
}

void GenBoapMc::produceFuncC(Node* n){
	BIter		i;
	BString		s;
	BList<Node*>*	nl;
	BString		retType;
	
	retType = getTypeName(n->node(0));
	
	ofileImpC.writeLine("char*	txData = opacket.data;\n");
	ofileImpC.writeLine("char*	rxData = opacket.data;\n");
	ofileImpC.writeLine("BUInt8&	errNum = (BUInt8&)*rxData; rxData += sizeof(errNum);\n");
	ofileImpC.writeLine("BError	err;\n");
	ofileImpC.writeLine("\n");

	ofileImpC.writeLine(BString("opacket.head.length = sizeof(opacket.head);\n"));
	ofileImpC.writeLine(BString("opacket.head.cmd = ") + ofuncNum + ";\n");
	ofileImpC.writeLine("// Push arguments\n");
	
	nl = &n->node(1)->nodes();
	for(nl->start(i); !nl->isEnd(i); nl->next(i)){
		if((nl->get(i)->node(0)->name() == "in") || (nl->get(i)->node(0)->name() == "inout")){
			ofileImpC.writeLine(BString("memcpy(txData, &") + nl->get(i)->node(2)->name() + ", sizeof(" + nl->get(i)->node(2)->name() + ")); txData += sizeof(" + nl->get(i)->node(2)->name() + "); opacket.head.length += sizeof("  + nl->get(i)->node(2)->name() + ");\n");
		}
	}

	if(retType == "oneway"){
		ofileImpC.writeLine("performSend();\n");
	}
	else {
		ofileImpC.writeLine("if(err = performCall()){\n");
		ofileImpC.indentMore();
		if(retType == "BError")
			ofileImpC.writeLine("return err;\n");
		else
			ofileImpC.writeLine("throw err;\n");
		ofileImpC.indentLess();
		ofileImpC.writeLine("}\n");

		ofileImpC.writeLine("// Pop arguments\n");
		nl = &n->node(1)->nodes();
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			if((nl->get(i)->node(0)->name() == "out") || (nl->get(i)->node(0)->name() == "inout"))
				ofileImpC.writeLine(BString("memcpy(&") + nl->get(i)->node(2)->name() + ", rxData, sizeof(" + nl->get(i)->node(2)->name() + ")); rxData += sizeof(" + nl->get(i)->node(2)->name() + ");\n");
		}
		ofileImpC.writeLine("err.set(errNum);\n");
		ofileImpC.writeLine("return err;\n");
	}
}

void GenBoapMc::produceImpC(Node* n){
	BString		s;
	BIter		i;
	BList<Node*>*	nl;

	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = n->name();
		ofileImpC.writeLine(BString("namespace ") + omodule + " {\n");
		ofileImpC.indentMore();
		
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpC(n->nodes()[i]);
		}
		ofileImpC.indentLess();
		ofileImpC.writeLine("}\n");
		break;
	case Node::TINTERFACE:
		ointerface = n->name();
		ofuncNum = 0;
		ofileImpC.writeLine(ointerface + "::" + ointerface + "(BComms& comms) : BoapMcClientObject(comms){\n");
		ofileImpC.indentMore();
		ofileImpC.writeLine(BString("oapiVersion = ") + oapiVersion + ";\n");
		ofileImpC.indentLess();
		ofileImpC.writeLine("}\n");
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpC(n->nodes()[i]);
		}
		break;
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpC(n->nodes()[i]);
		}
		break;
	case Node::TFUNC:
		if(getTypeName(n->node(0)) == "oneway"){
			s = s + "void ";
		}
		else {
			s = s + getTypeName(n->node(0)) + " ";
		}
		s = s + ointerface + "::" + n->name() + "(";
		nl = &n->node(1)->nodes();
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			if(i != nl->begin())
				s = s + ", ";
			if(nl->get(i)->node(0)->name() == "in"){
//				s = s + getTypeName(nl->get(i)->node(1)) + " ";
				s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			else if(nl->get(i)->node(0)->name() == "inref"){
				s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& ";
			}
			else {
				s = s + getTypeName(nl->get(i)->node(1)) + "& ";
			}

			s = s + nl->get(i)->node(2)->name();
		}
		s = s + "){\n";
		ofileImpC.writeLine(s);
		ofileImpC.indentMore();
		produceFuncC(n);
		ofileImpC.indentLess();
		ofileImpC.writeLine("}\n\n");
		ofuncNum++;
		break;
	case Node::TAPIVERSION:
		oapiVersion = n->name().retInt();
		break;
	default:
		break;
	}
}

void GenBoapMc::produceFuncCall(Node* n){
	BString		s;
	BIter		i;
	BList<Node*>*	nl;
	BString		typeName;
	int		a;

	switch(n->nodeType()){
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceFuncCall(n->nodes()[i]);
		}
		break;
	case Node::TFUNC:
		ofileImpS.writeLine(BString("case ") + ofuncNum + ": {\n");
		ofileImpS.indentMore();

		// Do args
		nl = &n->node(1)->nodes();
		for(nl->start(i), a = 0; !nl->isEnd(i); nl->next(i), a++){
			typeName = getTypeName(nl->get(i)->node(1));
			if((nl->get(i)->node(0)->name() == "in") || (nl->get(i)->node(0)->name() == "inout")){
				s = typeName + "&\targ" + a + " = (" + typeName + "&)*rxData; rxData += sizeof(" + typeName + ");\n";
			}
			else {
				s = typeName + "&\targ" + a + " = (" + typeName + "&)*txData; txData += sizeof(" + typeName + ");\n";
			}
			ofileImpS.writeLine(s);
		}

		// Call function
		for(nl->start(i), a = 0, s = ""; !nl->isEnd(i); nl->next(i), a++){
			if(s.len())
				s += ", ";
			s = s + "arg" + a;
		}
		if(getTypeName(n->node(0)) == "oneway"){
			ofileImpS.writeLine(n->name() + "(" + s + ");\n");
			ofileImpS.writeLine("oneway = 1;\n");
		}
		else {		
			ofileImpS.writeLine(BString("err = " ) + n->name() + "(" + s + ");\n");
		}
		ofileImpS.writeLine("break;\n");
		ofileImpS.writeLine("}\n");
		ofileImpS.indentLess();
		ofuncNum++;
		break;
	default:
		break;
	}
}

void GenBoapMc::produceImpS(Node* n){
	BString		s;
	BIter		i;

	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = n->name();
		ofileImpS.writeLine(BString("namespace ") + omodule + " {\n");
		ofileImpS.indentMore();
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpS(n->nodes()[i]);
		}
		ofileImpS.indentLess();
		ofileImpS.writeLine("}\n");
		break;
	case Node::TINTERFACE:
		ointerface = n->name();
		ofuncNum = 0;
		ofileImpS.writeLine(ointerface + "Service::" + ointerface + "Service(){\n");
		ofileImpS.indentMore();
		ofileImpS.writeLine(BString("oapiVersion = ") + oapiVersion + ";\n");
		ofileImpS.indentLess();
		ofileImpS.writeLine("}\n");

		
		ofileImpS.writeLine(BString("BError\t") + ointerface + "Service::processPacket(BoapMcPacket& rx, BoapMcPacket& tx){\n");
		ofileImpS.indentMore();
		ofileImpS.writeLine("char*	rxData = rx.data;\n");
		ofileImpS.writeLine("char*	txData = tx.data;\n");
		ofileImpS.writeLine("bool	oneway = 0;\n");
		ofileImpS.writeLine("BUInt8&	errNum = (BUInt8&)*txData; txData += sizeof(errNum);\n");
		ofileImpS.writeLine("BError	err;\n\n");
		ofileImpS.writeLine("switch(rx.head.cmd){\n");
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceFuncCall(n->nodes()[i]);
		}
		ofileImpS.writeLine("}\n");
		ofileImpS.writeLine("if(oneway){\n");
		ofileImpS.indentMore();
		ofileImpS.writeLine("tx.head.length = 0;\n");
		ofileImpS.indentLess();
		ofileImpS.writeLine("}\n");
		ofileImpS.writeLine("else {\n");
		ofileImpS.indentMore();
		ofileImpS.writeLine("errNum = err.num();\n");
		ofileImpS.writeLine("tx.head.length = sizeof(tx.head) + BUInt(txData - tx.data);\n");
		ofileImpS.writeLine("tx.head.addressTo = rx.head.addressFrom;\n");
		ofileImpS.indentLess();
		ofileImpS.writeLine("}\n");
		ofileImpS.writeLine("return err;\n");
		ofileImpS.indentLess();
		ofileImpS.writeLine("}\n");
		break;
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			produceImpS(n->nodes()[i]);
		}
		break;
	case Node::TFUNC:
		break;
	case Node::TAPIVERSION:
		oapiVersion = n->name().retInt();
		break;
	default:
		break;
	}
}

BError GenBoapMc::produceHeaderIntC(){
	BError	err;
	BString	fileName = ofileName + "C.h";
	BString	fileNameDef = ofileName + "C_H";

	ofileIntC.printf("/*******************************************************************************\n");
	ofileIntC.printf(" *\t%s\tProduced by Bidl\n", fileName.retStr());
	ofileIntC.printf(" *******************************************************************************\n");
	ofileIntC.printf(" */\n");
	ofileIntC.printf("\n");
	ofileIntC.printf("#ifndef %s\n", fileNameDef.retStr());
	ofileIntC.printf("#define %s 1\n\n", fileNameDef.retStr());

	ofileIntC.printf("#include <BTypes.h>\n");
	ofileIntC.printf("#include <BoapMc.h>\n");
	ofileIntC.printf("#include <%sD.h>\n\n", ofileName.retStr());
	ofileIntC.printf("\n");
	return err;
}

BError GenBoapMc::produceHeaderIntS(){
	BError	err;
	BString	fileName = ofileName + "S.h";
	BString	fileNameDef = ofileName + "S_H";

	ofileIntS.printf("/*******************************************************************************\n");
	ofileIntS.printf(" *\t%s\tProduced by Bidl\n", fileName.retStr());
	ofileIntS.printf(" *******************************************************************************\n");
	ofileIntS.printf(" */\n");
	ofileIntS.printf("\n");
	ofileIntS.printf("#ifndef %s\n", fileNameDef.retStr());
	ofileIntS.printf("#define %s 1\n\n", fileNameDef.retStr());

	ofileIntS.printf("#include <BTypes.h>\n");
	ofileIntS.printf("#include <BoapMc.h>\n");
	ofileIntS.printf("#include <%sD.h>\n", ofileName.retStr());
	ofileIntS.printf("\n");

	if(ooptions.hasKey("connectionClass")){
		ofileIntS.printf("class %s;\n\n", ooptions["connectionClass"].retStr());
	}

	return err;
}

BError GenBoapMc::produceTrailerInt(){
	BError	err;
	
	ofileIntC.printf("#endif\n");
	ofileIntS.printf("#endif\n");
	return err;
}

BError GenBoapMc::produceHeaderImpC(){
	BError	err;

	ofileImpC.printf("/*******************************************************************************\n");
	ofileImpC.printf(" *\t%s\tProduced by Bidl\n", (ofileName + ".cc").retStr());
	ofileImpC.printf(" *******************************************************************************\n");
	ofileImpC.printf(" */\n");
	ofileImpC.printf("\n");
	ofileImpC.printf("#include <%s>\n", (ofileName + "C.h").retStr());
	ofileImpC.printf("#include <string.h>\n");
	ofileImpC.printf("\n");
	return err;
}

BError GenBoapMc::produceHeaderImpS(){
	BError	err;

	ofileImpS.printf("/*******************************************************************************\n");
	ofileImpS.printf(" *\t%s\tProduced by Bidl\n", (ofileName + ".cc").retStr());
	ofileImpS.printf(" *******************************************************************************\n");
	ofileImpS.printf(" */\n");
	ofileImpS.printf("\n");
	ofileImpS.printf("#include <%s>\n", (ofileName + "D.h").retStr());
	ofileImpS.printf("#include <%s>\n", (ofileName + "S.h").retStr());
	ofileImpS.printf("\n");
	
	return err;
}

BString GenBoapMc::getTypeSwapList(Node* n){
	BString	typeName;
	Type*	t;
	BIter	i;
	BString	typeList;

	typeName = n->name();
//	printf("isRawType: %d %s\n", n->nodeType(), typeName.retStr());

	if(n->nodeType() == Node::TTYPEARRAY){
		return "";
	}
	else if(n->nodeType() == Node::TTYPEDICT){
		return "";
	}
	else if(n->nodeType() == Node::TTYPE){
		if(typeName == "Int8")		return "1";
		else if(typeName == "UInt8")	return "1";
		else if(typeName == "Int16")	return "2";
		else if(typeName == "UInt16")	return "2";
		else if(typeName == "Int32")	return "4";
		else if(typeName == "UInt32")	return "4";
		else if(typeName == "Bool")	return "4";
		else if(typeName == "String")	return "";
		else if(typeName == "Error")	return "";
		else if(typeName == "Date")	return "";
		else if(typeName == "DateTime")	return "";
		else if(typeName == "Id")	return "";
		else if(typeName == "ObjData")	return "";
		else if(typeName == "TimeStamp")	return "";
		else if(typeName == "Complex")	return "";
		else {
			if(t = gtypelist.search(typeName)){
				if(t->node()){
					return  getTypeSwapList(t->node());
				}
			}
			else
				return "";
		}
	}
	else if(n->nodes().number()){
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			typeList += getTypeSwapList(n->nodes()[i]);
		}

		return typeList;
	}
	return "";
}



GenBoapMc::GenBoapMc(){
	ofuncNum = 0;
	opushPopDepth = 0;
	oapiVersion = 0;
	
	setUseBObjects(0);
}

GenBoapMc::~GenBoapMc(){
}

BError GenBoapMc::produce(Node* n, BString fileName){
	BError	err;
	
//	dprintf("GenBoapMc::produce: %x\n", n);
	ofileName = fileName;
	ofileIntC.open(fileName + "C.h", "w");
	ofileIntS.open(fileName + "S.h", "w");
	ofileImpC.open(fileName + "C.cpp", "w");
	ofileImpS.open(fileName + "S.cpp", "w");
	
	// File Headers
	produceHeaderIntC();
	produceHeaderIntS();
	produceHeaderImpC();
	produceHeaderImpS();
	
	// Generate code
	produceIntC(n);
	produceIntS(n);
	produceImpC(n);
	produceImpS(n);
	
	// Generate trailers
	produceTrailerInt();
	ofileImpS.close();
	ofileImpC.close();
	ofileIntS.close();
	ofileIntC.close();
	return err;
}

