/*
** <admxrc2/physdma.h> - Defines functions for ADMXRC2 API Physical DMA
**                       extension.
**
** (C) Copyright 2006, 2014 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_PHYSDMA_H
#define _ADATA_ADMXRC2_PHYSDMA_H

#include <admxrc2.h>
#include <admxrc2/physdmas.h>

#ifdef __cplusplus
extern "C" {
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_DoDMAPhysical(
  ADMXRC2_HANDLE        hCard,
  ADMXRC2_PHYSDMA_DESC* pBufferDescriptors, /* Pointer to array of buffer descriptors */
  unsigned long         numDescriptor,      /* Number of elements at 'phBufferDescriptor' */
  ADMXRC2_DMADIR        direction,
  unsigned int          dmaChannel,
  _ADMXRC2_UINT32       dmaMode,
  _ADMXRC2_UINT32       flags,
  unsigned long*        pTimeout,
#if defined(_WIN32) || defined(_MSC_VER)
  HANDLE                     hEvent);
#else
  void*                      pIgnored);
#endif

#ifdef __cplusplus
} 
#endif

#endif
