/*
** <admxrc2/debugtss.h> - Defines functions for ADMXRC2 Debug Timestamping extension.
**
** (C) Copyright 2016 Alpha Data
**
** Timestamp entries are 16 bytes each, consisting of
*/

#ifndef _ADATA_ADMXRC2_DEBUGTS_H
#define _ADATA_ADMXRC2_DEBUGTS_H

#include <admxrc2.h>
#include <admxrc2/debugtss.h>
#include <admxrc2/debugtst.h>

#ifdef __cplusplus
extern "C" {
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetDebugTSInfo(
  ADMXRC2_HANDLE             hCard,
  _ADMXRC2_UINT32            facility,      /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  ADMXRC2_DEBUGTS_INFO*      pDebugTSInfo); /* Information about timestampable facility and current status of buffer */

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetDebugTSStatus(
  ADMXRC2_HANDLE             hCard,
  _ADMXRC2_UINT32            facility,        /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  ADMXRC2_DEBUGTS_STATUS*    pDebugTSStatus); /* Current status of timestamp buffer in facility */

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ReadDebugTS(
  ADMXRC2_HANDLE             hCard,
  _ADMXRC2_UINT32            facility,      /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */
  size_t                     offset,        /* Offset from current head pointer, in entries */
  size_t                     count,         /* Number of entries to read */
  _ADMXRC2_UINT32            flags,         /* See ADMXRC2_DEBUGTS_FLAG_* values */
  void*                      pTSBuffer);    /* May be NULL */

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ResetDebugTS(
  ADMXRC2_HANDLE             hCard,
  _ADMXRC2_UINT32            facility);     /* Identifies timestampable facility; see ADMXRC2_DEBUGTS_FACILITY_* values */

#ifdef __cplusplus
} 
#endif

#endif
