#include <linux/file.h>
#include <linux/mm.h>

/*
** test-io_remap_pfn_range.c
**
** This file can be used to check whether the io_remap_pfn_range()
** function exists (2.6.x kernels only).
*/

static int
fops_mmap(
  struct file*           filp,
  struct vm_area_struct* vma)
{
  if (io_remap_pfn_range(vma,
			 vma->vm_start,
			 0,
			 1,
			 vma->vm_page_prot)) {
    /* Do nothing */
  }

  return 0;
}
