/*
** File: mapio.c  
** Project: Linux Driver Framework
** Purpose: Mechanism by which OS-independent driver code can map device memory
**          into the driver's address space.
**
** (C) Copyright Alpha Data 2010
*/

#include "df.h"
#include "dflinux.h"

extern void*
dfIoSpaceMap(
  DfDeviceObject* pDevObj, /* not used */
  DfBusResources* pResources,
  unsigned int barIndex,
  uint64_t offset,
  uint64_t length,
  DfMemoryHandle* pHandle)
{
  void* p;
  DfPciBar* pBar;

  /* Sanity checks */
  dfAssert(length < (unsigned long)-1);
  dfAssert(offset + length >= offset);
  dfAssert(pDevObj->hardwareId.busType == DfBusPci);
  dfAssert(barIndex < pResources->variant.pci.numMemBar);
  pBar = &pResources->variant.pci.memBar[barIndex];
  dfAssert(offset < pBar->size);
  dfAssert(offset + length <= pBar->size);
  p = ioremap((resource_size_t)(pBar->base + offset), (unsigned long)length);
  if (NULL != p) {
    *pHandle = NULL;
  }
  return p;
}

boolean_t
dfIoSpaceUnmap(
  DfDeviceObject* pDevObj, /* not used */
  void* pKernelAddress)
{
  iounmap(pKernelAddress);
  return TRUE;
}
