/*
** File: dflinux.h  
** Project: Linux Driver Framework
** Purpose: Defines API used by Linux-dependent driver code
**
** (C) Copyright Alpha Data 2010
*/

#if !defined(ADATA_DF_DFLINUX_H)
#define ADATA_DF_DFLINUX_H

/* Maximum number of entries in a DMA mapping table */
#define DF_DMA_MAPPER_MAX_TABLE_LENGTH (0x40)

/* Maximum number of page pointers in a buffer description region */
#define DF_BUFFER_DESCRIPTION_REGION_SIZE (4096)

typedef struct _DfLinuxDriverParameterUint32 {
  const char* pName;
  unsigned int* pValue;
} DfLinuxDriverParameterUint32;

typedef struct _DfLinuxDriverParameterBoolean {
  const char* pName;
  unsigned int* pValue;
} DfLinuxDriverParameterBoolean;

typedef struct _DfLinuxDriverParameterString {
  const char* pName;
  const char* pValue;
} DfLinuxDriverParameterString;

#define DFLINUX_MAX_IOCTL_SIZE (64)

struct _DfLinuxClientRequestNonBlock {
  struct {
    uint8_t data[DFLINUX_MAX_IOCTL_SIZE];
  } ioctlStruct;
  DfClientRequest clientRequest;
};

struct _DfExportedInterface {
  DfDeviceObject* pDevObj;
  char name[32];
  unsigned int size;
  void* pInterfaceStruct;
  void* pInterfaceContext;
  DfExportedInterface* pNext;
};

struct _DfImportedInterface {
  char name[32];
  unsigned int size;
  DfImportedInterface* pNext;
};

struct _DfLinuxDmaMapperContext {
  DfDeviceObject* pDeviceObject;
  unsigned int index;
  DfDmaMapperNode* pTable;

  struct {
    unsigned int numEntry;
    boolean_t bWriteToDevice;
#if DF_DBG_BUILD
    boolean_t bIdle;
#endif
  } curr;
};

struct _DfMmappableRegion {
  struct {
    DfMmappableRegion* pNext;
    uint32_t regionTag;
    boolean_t bIsMemory;     /* TRUE => use remap_pfn_range; FALSE => use io_remap_pfn_range */
    unsigned long pfnStart;  /* page frame number of aligned region */
    unsigned long pfnEnd;    /* page frame number of end of aligned region */
    unsigned int pageOffset; /* offset from page frame boundary of (possibly) unaligned region */
    size_t kernelSize;       /* size of region in bytes of (possibly) unaligned region */
  } system;
};

extern void
dfLinuxModuleExitPci(
  void);

extern int
dfLinuxModuleInitPci(
  const char* pciDriverName,
  struct pci_device_id* pPciIdTable,
  boolean_t bSupportLegacyHardware);

extern DfMmappableRegion*
dfLinuxMmappableRegionFind(
  DfDeviceObject* pDevObj,
  unsigned long pfn);

extern void
dfLinuxUserIfInit(
  void);

extern void
dfLinuxCheckDataTypes(
  void);

extern const char g_dfDriverName[];

extern DfLinuxDriverParameterUint32  g_dfLinuxDriverParamUint32[];
extern DfLinuxDriverParameterBoolean g_dfLinuxDriverParamBoolean[];
extern DfLinuxDriverParameterString  g_dfLinuxDriverParamString[];

#endif
